<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;

class AlbumCategory extends Model{

	use Afrodien;

	protected $table = 'albums_categories';

	public function albums(){
		return $this->hasMany(Album::class,'category');
	}

	public function Structure(){
		$Locale = \App::getLocale();
		$this['title']         = isset($this['title_'.$Locale]) ? $this['title_'.$Locale] : "";
		$this['description']   = isset($this['description_'.$Locale]) ? $this['description_'.$Locale] : "";
		$this['featuredImage'] = $this->getFeaturedImage();
		$this['thumbnail']     = $this->thumbnail();
		$this['url']           = $this->url();
	}

	public function thumbnail($Quality=100){
		if(
			isset($this->featured_image) && !empty($this->featured_image)
			&& \file_exists(storage_path('app/public/images/thumbnail/'.$Quality.'/',$this->featured_image.'.webp'))
		){
			$image = $this->image('/images/thumbnail/'.$Quality.'/',$this->featured_image.'.webp');
		}else{
			$image = $this->getFeaturedImage();
		}
		return $image;
	}


	public function getFeaturedImage(){
		if(isset($this->featured_image) && !empty($this->featured_image) && \file_exists(storage_path('app/public/images/original/'.$this->featured_image))){
			$image = $this->image('/images/original/',$this->featured_image);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

	public function url(){
		return route('frontend.albums.categories.view',['category'=>$this->slug]);
	}

	public function scopeActive($query) {
		return $query->where('status', 'published')->where('title_'.\Config::get('app.locale'), '!=', '');
	}

}
