<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class MailerCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mailer:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
		\Log::info("Newsletter Cron is working fine!");
		$Newsletters = \DB::select(" select * from `newsletters_sent` where `status` = 'inprogress' limit 1 ");
		foreach ($Newsletters as $Newsletter) {
			$Emails = \DB::select(" select * from `newsletter_subscribers` where `status` = 'active' and `id` > ? limit 10 ",[$Newsletter->at]);
			foreach ($Emails as $Email) {
				Mail::send([], [], function ($message) use ($Newsletter,$Email){
					$message->from(\Config::get('app.newsletter.email'), \Config::get('app.name')[\Config::get('app.locale')]);
					$message->to($Email->email,$Email->name);
					$message->setBody(\base64_decode($Newsletter->body), 'text/html');
					$message->setSubject($Newsletter->title);
				});
				\DB::update("update `newsletters_sent` set `total_sent`=`total_sent`+1 , `at` = ? ",[$Email->id]);
			}
			$CheckStatus1 = \DB::select(" select `id` from `newsletter_subscribers` order by `id` desc limit 1 ");
			$CheckStatus2 = \DB::select(" select `at` from `newsletters_sent` where `id` = ? ",[$Newsletter->id]);
			if($CheckStatus1[0]->id==$CheckStatus2[0]->at){
				\DB::update("update `newsletters_sent` set `status`='completed' where `id` = ? ",[$Newsletter->id]);
			}
		}
		\Log::info("Newsletter Cron is working fine!");
        return 0;
    }
}
