<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DynamicModel extends Model{

	protected $table = '';
	protected $primaryKey = '';

	public function setKey($key){
		$this->primaryKey = $key;
	}

	public function setVirtualForm($VirtualForm){
		$this->table = 'form_'.$VirtualForm->id;
		$this->primaryKey = 'id';
	}


	public function setTable($table){
		$this->table = $table;
		$system = VirtualSystem::where('table','=',$this->table)->firstOrFail();
		$this->primaryKey = $system->key;

	}

	public function setSystem($system){
		$this->table = $system['table'];
		$this->primaryKey = $system['key'];

	}



}
