<?php

namespace App\Exceptions;

use Illuminate\Database\Eloquent\ModelNotFoundException;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable; // <-- ADD THIS


use App\Traits\Afrodien;

class Handler extends ExceptionHandler
{

	use Afrodien;

    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

	public $data = [];

    /**
     * Report or log an exception.
     *
     * @param  \Throwable  $exception
     * @return void
     *
     * @throws \Exception
     */
    public function report(Throwable $exception)
    {
        parent::report($exception);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Throwable  $exception
     * @return \Symfony\Component\HttpFoundation\Response
     *
     * @throws \Throwable
     */
    public function render($request, Throwable $exception)
    {

		if ($exception instanceof \Illuminate\Validation\ValidationException && $request->expectsJson()) {
		    return response()->json(['message' => __('The given data was invalid.'), 'errors' => $exception->validator->getMessageBag()], 422);
		}

		if ($exception instanceof \Illuminate\Session\TokenMismatchException && $request->expectsJson()) {
		    return response()->json(['message' => __('CSRF token mismatch.'), 'errors' => [] ], 419);
		}

		if ($this->isHttpException($exception) || $exception instanceof ModelNotFoundException ) {
			$StatusCode = '';
			if($this->isHttpException($exception)){
				$StatusCode = $exception->getStatusCode();
			}elseif($exception instanceof ModelNotFoundException){
				$StatusCode = '404';
			}
	        switch ($StatusCode) {
	            case '404':
					$this->prepareViewer();

					\Tracker::addToErrorReport();
					$this->data['title'] = __("Error 404");
					$this->data['meta'] = [];
					$this->data['meta']['robots'] = "";
					$this->data['meta']['keywords'] = "";
					$this->data['meta']['title'] = "";
					$this->data['meta']['description'] = "";
					$this->data['meta']['featuredImage'] = [];
					$this->data['meta']['featuredImage']['src'] = "";
					$this->data['meta']['featuredImage']['type'] = "";
					$this->data['meta']['featuredImage']['width'] = "";
					$this->data['meta']['featuredImage']['height'] = "";
					$this->data['meta']['canonical'] = url('error-404');

					$this->data['page'] = \App\Page::active()->with('slider')->where('slug', '=', 'error-404')->first();
					if ($this->data['page']) {
						$this->data['page']->structure();
						$this->data['title'] = $this->data['page']['title'];
					}

	                return \Response::view('themes.'.\Config::get('app.theme').'.pages.error-404',$this->data,404);
	                break;
	            default:
	                return $this->renderHttpException($exception);
	                break;
	        }
	    } else {
	        return parent::render($request, $exception);
	    }
    }
}
