<?php

namespace App\Helpers;

class Firebase {

	private $data;

	public function setPayload( $data ) {
		$this->data = $data;
	}

	public function getPush() {
		$response                 = [];
		$response['to']           = $this->data['to'];
		$response['title']        = $this->data['title'];
		$response['body']         = $this->data['body'];
		$response['image'] = "";
		if(isset($this->data['image']) &&!empty($this->data['image'])){
			$response['image']        = url('/storage/images/original/'.$this->data['image']);
		}

		$response['icon'] = "";
		if(isset($this->data['icon']) && !empty($this->data['icon'])){
			$response['icon']         = url('/storage/images/original/'.$this->data['icon']);
		}

		$response['badge']        = url('/storage/'.\Config::get('app.favicon'));

		$response['click_action'] = $this->data['click_action'];
		$response['timestamp']    = date( 'Y-m-d G:i:s' );
		return $response;
	}

    public function send($registration_ids){

		$data = $this->getPush();
		$id = \Str::uuid();
		\DB::insert(" Insert into `notifications_sent` SET
			`id` = ?,
			`to` = ?,
			`title` = ?,
			`body` = ?,
			`icon` = ?,
			`image` = ?,
			`click_action` = ?,
			`total_recipients` = ?,
			`created_at`= ?,
			`opened` = ?,
			`status` = ?,
			`result` = ?,
			`success_recipients` = ?,
			`failure_recipients` = ?
		",[
			$id,
			$data['to'],
			$data['title'],
			$data['body'],
			$data['icon'],
			$data['image'],
			$data['click_action'],
			count($registration_ids),
			date("Y-m-d H:i:s"),
			0,
			'',
			'',
			0,
			0
		]);
		$data['click_action'] = url('/notifications/'.$id);

		if($data['to']=="all_subscribers"){
			$fields = [
				'priority'         => 'high',
	            'data'             => $data
	        ];
	        return $this->sendPushNotificationToAll($fields,$id);
		}else{
			unset($data['to']);
	        $fields = [
				'priority'         => 'high',
	            'data'             => $data
	        ];
	        return $this->sendPushNotification($registration_ids,$fields,$id);
		}
    }

    private function sendPushNotificationToAll($fields,$notification_id){
		$url = 'https://fcm.googleapis.com/fcm/send';

		$headers = array(
			'Authorization: key=' . \Config::get('app.fcm.key'),
			'Content-Type: application/json'
		);

		$_Error_   = "";
		$_Result_  = "";
		$_Failure_ = 0;
		$_Success_ = 0;


		$fields['condition'] = "!('anytopicyoudontwanttouse' in topics)";

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, \json_encode($fields));

		// Execute post
		$result = curl_exec($ch);
		if ($result === false) {
			die('Curl failed: ' . curl_error($ch));
		}

		$_Result_ .= $result;
		if(empty($result)){
			$_Error_ = curl_error($CURL);
		}else{
			$curl_result = json_decode($result);
			if(property_exists($curl_result,'Error')){
				$_Error_ .= $curl_result->Error;
			}
			$_Success_ += intval($curl_result->success ?? 0);
			$_Failure_ += intval($curl_result->failure ?? 0);
		}

		// Close connection
		curl_close($ch);


		// Update >> Result
		if(isset($_Error_) && !empty($_Error_)){
			\DB::update("Update `notifications_sent` SET `status`='failed' WHERE `id`='".$notification_id."' ");
			$errors[] = $_Error_;
		}else{
			\DB::update("Update `notifications_sent` SET `status`='success', `result`='".$_Result_."', `success_recipients`='$_Success_', `failure_recipients`='".$_Failure_."' WHERE `id`='".$notification_id."' ");
			$SuccessMessage = "Success";
		}

		\UserActivity::addToLog("Pushed Notification");

		return ['message'=>'notifications sent', 'success'=>true];
	}

    private function sendPushNotification($registration_ids,$fields,$notification_id){

        $url = 'https://fcm.googleapis.com/fcm/send';

        $headers = array(
            'Authorization: key=' . \Config::get('app.fcm.key'),
            'Content-Type: application/json'
        );

		$_Error_   = "";
        $_Result_  = "";
        $_Failure_ = 0;
        $_Success_ = 0;

		$_registration_ids = array_chunk($registration_ids, 900);
        foreach($_registration_ids as $registration_ids){

			$fields['registration_ids'] = $registration_ids;
			//$fields['condition'] = "!('anytopicyoudontwanttouse' in topics)";

	        $ch = curl_init();
	        curl_setopt($ch, CURLOPT_URL, $url);
	        curl_setopt($ch, CURLOPT_POST, true);
	        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	        curl_setopt($ch, CURLOPT_POSTFIELDS, \json_encode($fields));

	        // Execute post
	        $result = curl_exec($ch);
	        if ($result === false) {
	            die('Curl failed: ' . curl_error($ch));
	        }

			$_Result_ .= $result;
            if(empty($result)){
                $_Error_ = curl_error($CURL);
            }else{
                $curl_result = json_decode($result);
                if(property_exists($curl_result,'Error')){
                    $_Error_ .= $curl_result->Error;
                }
                $_Success_ += intval($curl_result->success ?? 0);
                $_Failure_ += intval($curl_result->failure ?? 0);
            }

	        // Close connection
	        curl_close($ch);
		}

		// Update >> Result
        if(isset($_Error_) && !empty($_Error_)){
			\DB::update("Update `notifications_sent` SET `status`='failed' WHERE `id`='".$notification_id."' ");
            $errors[] = $_Error_;
        }else{
            \DB::update("Update `notifications_sent` SET `status`='success', `result`='".$_Result_."', `success_recipients`='$_Success_', `failure_recipients`='".$_Failure_."' WHERE `id`='".$notification_id."' ");
            $SuccessMessage = "Success";
        }

		\UserActivity::addToLog("Pushed Notification");

        return ['message'=>'notifications sent', 'success'=>true];
    }
}
