<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use App\Traits\Afrodien;


class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails,Afrodien;

    public function __construct()
    {
		$this->prepareViewer();
    }

    public $data = [];

	public function showLinkRequestForm(){
		$this->data['page'] = \App\Page::where('slug', '=', 'lost-password')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->getMeta();
	    return view('themes.'.\Config::get('app.theme').'.pages.lost-password',$this->data);
	}
}
