<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Traits\Afrodien;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers,Afrodien;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

	public $data = [];

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(){
        $this->middleware('guest')->except('logout');
		$this->prepareViewer();
    }

	protected function authenticated($request, $user){
		if ($user->can('dashboard-access')){
			return redirect()->route('dashboard.index');
		}elseif ($user->can('clientarea-access')){
			return redirect()->route('clientarea.index');
		}
		return redirect()->route('frontend.index');
	}

	public function showLoginForm(){
		$this->data['page'] = \App\Page::where('slug', '=', 'login')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->getMeta();
	    return view('themes.'.\Config::get('app.theme').'.pages.login',$this->data);
	}

}
