<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\SupportTicket;
use App\Traits\Afrodien;

class HomeController extends Controller{

	use Afrodien;

	public function __construct(){
		$this->prepareViewer();
    }

    public function index(){

		$data = [];

		$roles = \Auth::user()->roles;
		$Surveys = [];
		foreach ($roles as $role) {
			foreach ($role->surveys as $survey) {
				if($survey->status=='enabled'){
					$Surveys[$survey['id']] = $survey;
				}
			}
		}
		$data['Surveys'] = $Surveys;

        $data['tickets']       = SupportTicket::where('user_id',\auth()->id())->orderBy('id', 'desc')->take(5)->get();

        $data['totalCount']    = SupportTicket::where('user_id',\auth()->id())->count();
        $data['awaitingCount'] = SupportTicket::where('user_id',\auth()->id())->where('status','awaiting')->count();
        $data['inprogressCount'] = SupportTicket::where('user_id',\auth()->id())->where('status','inprogress')->count();
        $data['closedCount']   = SupportTicket::where('user_id',\auth()->id())->where('status','closed')->count();

        return view('customer.pages.index',$data);
    }

}
