<?php

namespace App\Http\Controllers\Customer;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Validator;
use Str;
use App\Traits\Afrodien;


class InvoiceController extends Controller{

	use Afrodien;

	public function __construct(){
		$this->prepareViewer();
    }

    public function index(){
        $Invoices = \App\SaleInvoice::where('user_id', Auth::id())->get();
        return view('customer.pages.invoices.index')->withInvoices($Invoices);
    }

    public function view($id){
        $Invoice = \App\SaleInvoice::where('invoice_id', $id)->with('items')->where('user_id',\auth()->id())->firstOrFail();
		if($Invoice){
			$Invoice->total = 0;
			$Invoice->items->each(function ($item) use ($Invoice){
				$Invoice->total += $item->quantity*$item->cost;
			});
		    return view('customer.pages.invoices.view')->withInvoice($Invoice);
        }

    }

}
