<?php

namespace App\Http\Controllers\Customer;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Validator;
use Str;
use App\Traits\Afrodien;


class ProductController extends Controller{

	use Afrodien;

	public function __construct(){
		$this->prepareViewer();
    }

    public function index()
    {
		$products = Auth()->user()->products;
        return view('customer.pages.products.index')->withProducts($products);
    }

    public function view($id)
    {
        $product = \App\UserProduct::where('id', $id)->where('user_id', auth()->user()->id)->with('details')->firstOrFail();
        if($product){
            return view('customer.pages.products.view')->withProduct($product);
        }

    }

}
