<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use Auth;
use Hash;
use Validator;
use App\Traits\Afrodien;


class ProfileController extends Controller{

	use Afrodien;

	public function __construct(){
		$this->prepareViewer();
    }

    public function edit(Request $request){
        $user = Auth::user();
        $name=explode(' ',$user->name);
        $user->fname=$name[0];
        $user->lname=$name[1];
        return view('customer.pages.profile.edit')->withUser($user);
    }

    public function viewChangePassword(){
      return view('customer.pages.profile.change-password');
    }

    public function update(Request $request){
		$data = [];

		$user = Auth::user();

		$validation = [];
		$validation['email']     = 'unique:users,email,'.$user->id.'|email|required';
		$validation['phone']     = "required";
		$validation['prefix']    = "required";
		$validation['name']      = "required";
		$validation['gender']    = "required";
		$validation['job_title'] = "required";
		$validation['about']     = "required";
		$validation['password']  =[
			'required', function ($attribute, $value, $fail) {
				if (!\Hash::check($value, Auth::user()->password)) {
					$fail('Your Password is wrong');
				}
			},
		];

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

		$data = $this->validate(request(), $validation, $validation_msgs);
		$data = request()->except(['password']);

		if(\Config::get('app.users.can-change-email')==1){	
			$user->email = $data['email'];
		}

		$user->phone = $data['phone'];
		$user->prefix = $data['prefix'];
		$user->name = $data['name'];
		$user->gender = $data['gender'];
		$user->job_title = $data['job_title'];
		$user->about = $data['about'];
		$user->update();

		\UserActivity::addToLog('Updated his profile.');

		$data['success'] = true;
		$data['message'] = __('profile has been updated!');

		return $data;

    }


    public function updatePassword(Request $request){
      $valid=Validator::make($request->all(),[
          'password'=>'required|confirmed'
      ]);

      if($valid->passes()){
        $data=$request->all();
        if(Hash::check($data['old-password'], Auth::User()->password)){
          $user = Auth::user();
          $user->password = Hash::make($data['password']);
          $user->save();

		  return redirect()->back()->with('success', 'Password changed successfully');
        }else{
			Redirect::back()->withErrors(['Old Password is Wrong']);
		}

      }else{
        return redirect()->back()->withErrors(["Password can't be empty"]);
      }



    }
}
