<?php


namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Config;

class ConfigurationController extends Controller
{
	public function index(){
        $data = [];
        $data['title'] = __('Configuration');
        return view('dashboard.pages.configuration.index',$data);
    }

	public function mainNav(){
        $data = [];
        $data['title'] = __('Configuration')." > ".__('Main Nav');
        return view('dashboard.pages.configuration.main-nav',$data);
    }

	public function adsManager(){
        $data = [];
        $data['title'] = __('Configuration')." > ".__('ADs Manager');
        return view('dashboard.pages.configuration.ads-manager',$data);
    }

	public function cookieNotification(){
		$data = [];
        $data['title'] = __('Configuration')." > ".__('Cookie Notification');
        return view('dashboard.pages.configuration.cookie-notification',$data);
    }

	public function socialMedia(){
        $data = [];
        $data['title'] = __('Configuration')." > ".__('Social Media');
        return view('dashboard.pages.configuration.social-media',$data);
    }

	public function mailSetup(){
        $data = [];
        $data['title'] = __('Configuration')." > ".__('Mail Setup');
        return view('dashboard.pages.configuration.mail-setup',$data);
    }

	public function emailTemplates(){
        $data = [];
        $data['title'] = __('Configuration')." > ".__('Email Templates');
        return view('dashboard.pages.configuration.email-templates',$data);
    }

	public function htmlCode(){
        $data = [];
        $data['title'] = __('Configuration')." > ".__('HTML Code');
        return view('dashboard.pages.configuration.html-code',$data);
    }

	public function contactInfo(){
        $data = [];
        $data['title'] = __('Configuration')." > ".__('Contact Info');
        return view('dashboard.pages.configuration.contact-info',$data);
    }

    public function update(){
		$data = [];

		$validation = [];

		if(\request('layout')=='configuration'){
			foreach(\Config::get('app.languages') as $language){
				$validation['name_'.$language->prefix]              = "required";
				$validation['slogan_'.$language->prefix]            = "required";
				$validation['description_'.$language->prefix]       = "required";
				$validation['customer-area-title_'.$language->prefix]       = "required";
				$validation['copyright_'.$language->prefix]         = "required";
			}
			$validation['favicon']           = "required";
			$validation['logo']              = "required";
			$validation['logo_icon']              = "required";
			$validation['featuredImage']     = "required";
			$validation['defaultTimeZone']   = "required";
			$validation['itemsPerPage']      = "required";
			$validation['allowedExtensions'] = "array|required";
			$validation['maxFileSize']       = "required";
			$validation['theme']             = "required";
			$validation['defaultLanguage']   = "required";
			$validation['www']               = "";
			$validation['https']             = "";
		}elseif(\request('layout')=='main-nav'){
			$validation['main-nav'] = "required|array";
		}elseif(\request('layout')=='ads-manager'){
			$validation['auto_ad']   = "";
			$validation['header_ad'] = "";
			$validation['footer_ad'] = "";
		}elseif(\request('layout')=='social-media'){
			$validation['facebook-app']          = "";
			$validation['facebook']          = "";
			$validation['twitter']           = "";
			$validation['instagram']           = "";
			$validation['linkedin']           = "";
		}elseif(\request('layout')=='cookie-notification'){
			foreach(\Config::get('app.languages') as $language){
				$validation['cookie_text_'.$language->prefix]         = "required";
			}
			$validation['CookieNotificationEnabled'] = "";
			$validation['cookie_page'] = "required";
			$validation['cookie_enabled'] = "required";
		}elseif(\request('layout')=='mail-setup'){
			$validation['contact_email'] = "required|email";
			$validation['contact_password'] = "";
			$validation['support_email'] = "";
			$validation['support_password'] = "";
			$validation['newsletter_email'] = "";
			$validation['newsletter_password'] = "";
			$validation['smtpHost'] = "";
			$validation['smtpPort'] = "";
			$validation['imapHost'] = "";
			$validation['imapPort'] = "";
		}elseif(\request('layout')=='email-templates'){
			$validation['contact_email'] = "required";
			$validation['newsletter_email'] = "";
		}elseif(\request('layout')=='html-code'){
			$validation['head_html'] = "";
			$validation['body_html'] = "";
		}elseif(\request('layout')=='contact-info'){
			$validation['mlh_location_en'] = "required";
			$validation['mlh_location_ar'] = "required";
			$validation['mlh_phone1'] = "required";
			$validation['mlh_phone2'] = "required";
			$validation['mlh_fax'] = "required";
			$validation['mlh_email'] = "required";
			$validation['mlh_map'] = "required";

			$validation['hok_location_en'] = "required";
			$validation['hok_location_ar'] = "required";
			$validation['hok_phone1'] = "required";
			$validation['hok_phone2'] = "required";
			$validation['hok_fax'] = "required";
			$validation['hok_email'] = "required";
			$validation['hok_map'] = "required";
		}

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

        $config = $this->validate(request(), $validation,$validation_msgs);

		if(\request('layout')=='configuration'){

			foreach(\Config::get('app.languages') as $language){
				$config['name'][$language->prefix]        = $config['name_'.$language->prefix];
				$config['slogan'][$language->prefix]      = $config['slogan_'.$language->prefix];
				$config['description'][$language->prefix] = $config['description_'.$language->prefix];
				$config['copyright'][$language->prefix]   = $config['copyright_'.$language->prefix];
				$config['customer-area-title'][$language->prefix]   = $config['customer-area-title_'.$language->prefix];
			}

			$config['name'] = \json_encode($config['name']);
			$config['slogan'] = \json_encode($config['slogan']);
			$config['description'] = \json_encode($config['description']);
			$config['copyright'] = \json_encode($config['copyright']);
			$config['customer-area-title'] = \json_encode($config['customer-area-title']);
			$config['allowedExtensions'] = implode(',',$config['allowedExtensions']);

			\App\Config::where('name','app.name')->update(['value' => $config['name']]);
			\App\Config::where('name','app.slogan')->update(['value' => $config['slogan']]);
			\App\Config::where('name','app.description')->update(['value' => $config['description']]);
			\App\Config::where('name','app.copyright')->update(['value' => $config['copyright']]);
			\App\Config::where('name','app.customer-area.title')->update(['value' => $config['customer-area-title']]);

			\App\Config::where('name','app.https')->update(['value' => $config['https'] ?? '']);
			\App\Config::where('name','app.www')->update(['value' => $config['www'] ?? '' ]);

			\App\Config::where('name','upload.max.filesize')->update(['value' => $config['maxFileSize']]);
			\App\Config::where('name','upload.allowed.extensions')->update(['value' => $config['allowedExtensions']]);

			\App\Config::where('name','app.favicon')->update(['value' => $config['favicon']]);
			\App\Config::where('name','app.logo.src')->update(['value' => $config['logo']]);
			\App\Config::where('name','app.logo.icon')->update(['value' => $config['logo_icon']]);
			\App\Config::where('name','app.default.featuredImage')->update(['value' => $config['featuredImage']]);

			\App\Config::where('name','app.locale')->update(['value' => $config['defaultLanguage']]);
			\App\Config::where('name','app.fallback_locale')->update(['value' => $config['defaultLanguage']]);
			\App\Config::where('name','app.timezone')->update(['value' => $config['defaultTimeZone']]);
			\App\Config::where('name','app.theme')->update(['value' => $config['theme']]);
			\App\Config::where('name','app.itemsPerPage')->update(['value' => $config['itemsPerPage']]);

		}elseif(\request('layout')=='cookie-notification'){

			foreach(\Config::get('app.languages') as $language){
				$config['cookie_text'][$language->prefix]   = $config['cookie_text_'.$language->prefix];
			}

			$config['cookie_text'] = \json_encode($config['cookie_text']);


			\App\Config::where('name','app.cookie.text')->update(['value' => $config['cookie_text']]);
			\App\Config::where('name','app.cookie.enabled')->update(['value' => $config['cookie_enabled'] ?? '' ]);
			\App\Config::where('name','app.cookie.page')->update(['value' => $config['cookie_page'] ?? '' ]);

		}elseif(\request('layout')=='main-nav'){
			\file_put_contents(\resource_path("views/themes/".\Config::get('app.theme')."/main-nav.json"),\json_encode($config['main-nav']));
		}elseif(\request('layout')=='ads-manager'){
			\App\Config::where('name','app.ad.auto')->update(['value' => $config['auto_ad']]);
			\App\Config::where('name','app.ad.header')->update(['value' => $config['header_ad']]);
			\App\Config::where('name','app.ad.footer')->update(['value' => $config['footer_ad']]);
		}elseif(\request('layout')=='social-media'){
			\App\Config::where('name','app.social.facebook.app')->update(['value' => $config['facebook-app']]);
			\App\Config::where('name','app.social.facebook.page')->update(['value' => $config['facebook']]);
			\App\Config::where('name','app.social.twitter')->update(['value' => $config['twitter']]);
			\App\Config::where('name','app.social.instagram')->update(['value' => $config['instagram']]);
			\App\Config::where('name','app.social.linkedin')->update(['value' => $config['linkedin']]);
		}elseif(\request('layout')=='mail-setup'){
			\App\Config::where('name','mail.mailers.smtp.host')->update(['value' => $config['smtpHost']]);
			\App\Config::where('name','mail.mailers.smtp.port')->update(['value' => $config['smtpPort']]);

			\App\Config::where('name','mail.mailers.imap.host')->update(['value' => $config['imapHost']]);
			\App\Config::where('name','mail.mailers.imap.port')->update(['value' => $config['imapPort']]);

			\App\Config::where('name','app.contact.credential.email')->update(['value' => $config['contact_email']]);
			\App\Config::where('name','app.contact.credential.password')->update(['value' => $config['contact_password']]);

			\App\Config::where('name','app.support.credential.email')->update(['value' => $config['support_email']]);
			\App\Config::where('name','app.support.credential.password')->update(['value' => $config['support_password']]);

			\App\Config::where('name','app.newsletter.credential.email')->update(['value' => $config['newsletter_email']]);
			\App\Config::where('name','app.newsletter.credential.password')->update(['value' => $config['newsletter_password']]);
		}elseif(\request('layout')=='email-templates'){
			\file_put_contents(\resource_path("views/emails/ThankYouConatctMail.blade.php"),$config['contact_email']);
			\file_put_contents(\resource_path("views/emails/verifyNewsletterMail.blade.php"),$config['newsletter_email']);

		}elseif(\request('layout')=='html-code'){
			\App\Config::where('name','app.head.html')->update(['value' => $config['head_html']]);
			\App\Config::where('name','app.body.html')->update(['value' => $config['body_html']]);
		}elseif(\request('layout')=='contact-info'){

			\App\Config::where('name','mlh.location.en')->update(['value' => trim($config['mlh_location_en'])]);
			\App\Config::where('name','mlh.location.ar')->update(['value' => trim($config['mlh_location_ar'])]);
			\App\Config::where('name','mlh.phone1')->update(['value' => trim($config['mlh_phone1'])]);
			\App\Config::where('name','mlh.phone2')->update(['value' => trim($config['mlh_phone2'])]);
			\App\Config::where('name','mlh.fax')->update(['value' => trim($config['mlh_fax'])]);
			\App\Config::where('name','mlh.email')->update(['value' => trim($config['mlh_email'])]);
			\App\Config::where('name','mlh.map')->update(['value' =>  base64_encode($config['mlh_map']) ]);

			\App\Config::where('name','hok.location.en')->update(['value' => trim($config['hok_location_en'])]);
			\App\Config::where('name','hok.location.ar')->update(['value' => trim($config['hok_location_ar'])]);
			\App\Config::where('name','hok.phone1')->update(['value' => trim($config['hok_phone1'])]);
			\App\Config::where('name','hok.phone2')->update(['value' => trim($config['hok_phone2'])]);
			\App\Config::where('name','hok.fax')->update(['value' => trim($config['hok_fax'])]);
			\App\Config::where('name','hok.email')->update(['value' => trim($config['hok_email'])]);
			\App\Config::where('name','hok.map')->update(['value' => base64_encode($config['hok_map'])]);
		}




		\UserActivity::addToLog('Updated website config.');

		$data['success'] = true;
		$data['message'] = 'configuration updated';

        return $data;
    }
}
