<?php

namespace App\Http\Controllers\Dashboard\Developers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class APIController extends Controller{

    public $database = [];

    public function index(){
        $data = [];
        $data['title'] = __('API');
        $data['data'] = \App\API::all();
        return view('dashboard.pages.system-builder.index', $data);
    }

    public function delete(){
        $data = [];

        $validation = [
            'record_id' => 'required',
        ];

		$inputs = \Afrodien::validate($request,$validation);

        $VirtualSystem = \App\VirtualSystem::find($inputs['record_id']);
        if($VirtualSystem){
			\SystemBuilder::delete($VirtualSystem);
            $VirtualSystem->forceDelete();
            $data['success'] = true;
            $data['message'] = 'record deleted';
        }else{
            $data['success'] = false;
            $data['message'] = "record id is invalid";
        }

		\UserActivity::addToLog('deleted Virtual System #'.$inputs['record_id'].' name: '.$VirtualSystem->slug);

        return $data;
    }

    public function edit(){
        $data = [];
        $data['title'] = __('Edit Virtual System');
        $data['system'] = \request('system_id');
        $data['system']->fields = json_decode($data['system']->fields,true);
        return view('dashboard.pages.system-builder.form', $data);
    }

    public function create(){
        $data = [];
        $data['title'] = __('New Virtual System');
        return view('dashboard.pages.system-builder.form', $data);
    }

    public function update(Request $request){
        $data = [];

		$VirtualSystem = \request('system_id');

	    $validation = [
            'system_name' => [
                'required',
                'unique:virtual_systems,slug,'.$VirtualSystem->id,
                'regex:/^[a-zA-Z-_]+$/'
            ],
            'notes' => 'required',
            'title_en' => 'required',
            'title_ar' => 'required',
            'system_fields' => 'required|array',
            'operations' => 'required|array',
        ];

		$inputs = \Afrodien::validate($request,$validation);

        $fields      = $inputs['system_fields'];
        $system_slug = \Str::slug($inputs['system_name'], '-');
        $table_name  = \Str::slug($inputs['system_name'], '_');

		foreach(\Config::get('app.languages') as $language){
			$title_prefix = 'title_'.$language->prefix;
			$VirtualSystem->$title_prefix = $inputs[$title_prefix];
		}

		$VirtualSystem->key        = 'id';
		$VirtualSystem->notes      = $inputs['notes'];
        $VirtualSystem->fields     = json_encode($fields);
        $VirtualSystem->slug       = $system_slug;
        $VirtualSystem->table      = $table_name;
        $VirtualSystem->operations = implode(',',$inputs['operations']);
        $VirtualSystem->update();

		$VirtualSystem->fields = $fields;

		\SystemBuilder::create($VirtualSystem);

		\UserActivity::addToLog('updated Virtual System #'.$VirtualSystem->id.' name: '.$VirtualSystem->slug);

        $data['success'] = true;
        $data['message'] = 'system updated successfully.';

        return json_encode($data);
    }

    public function store(Request $request){
        $data = [];
        $validation = [
            'system_name' => [
                'required',
                'unique:virtual_systems,slug',
                'regex:/^[a-zA-Z-_]+$/'
            ],
            'notes' => 'required',
            'title_en' => 'required',
            'title_ar' => 'required',
            'system_fields' => 'required|array',
            'operations' => 'required|array',
        ];

		$inputs = \Afrodien::validate($request,$validation);

        $fields      = $inputs['system_fields'];
        $system_slug = \Str::slug($inputs['system_name'], '-');
        $table_name  = \Str::slug($inputs['system_name'], '_');

        $VirtualSystem = new \App\VirtualSystem();

		foreach(\Config::get('app.languages') as $language){
			$title_prefix = 'title_'.$language->prefix;
			$VirtualSystem->$title_prefix = $inputs[$title_prefix];
		}

        $VirtualSystem->key        = 'id';
        $VirtualSystem->slug       = $system_slug;
        $VirtualSystem->table      = $table_name;
		$VirtualSystem->notes      = $inputs['notes'];
        $VirtualSystem->fields     = json_encode($fields);
        $VirtualSystem->operations = implode(',',$inputs['operations']);
        $VirtualSystem->save();

		$VirtualSystem->fields = $fields;

		\SystemBuilder::create($VirtualSystem);

        $data['success'] = true;
        $data['message'] = 'system created successfully.';

		\UserActivity::addToLog('added new Virtual System #'.$VirtualSystem->id.' - name : '.$VirtualSystem->slug);

        return json_encode($data);
    }

}
