<?php

namespace App\Http\Controllers\Dashboard\Developers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class FormBuilderController extends Controller{

    public $database = [];

	public function listTableField(){
        $data = [];
        $columns = \DB::select("SHOW COLUMNS FROM `". \request('table') ."` like '%".\request('search')."%'  ");
        foreach ($columns as $column){
            $row = [];
            $row['id'] = $column->Field;
            $row['text'] = $column->Field;
            $data['results'][] = $row;
        }
        return $data;
    }

    public function index(){
        $data = [];
        $data['title'] = __('Form Builder');
        $data['data'] = \App\VirtualForm::all();
        return view('dashboard.pages.form-builder.index', $data);
    }

    public function delete(Request $request){
        $data = [];

        $validation = [
            'record_id' => 'required',
        ];

		$inputs = \Afrodien::validate($request,$validation);

        $VirtualForm = \App\VirtualForm::find($inputs['record_id']);
        if($VirtualForm){
			\FormBuilder::delete($VirtualSystem);
            $VirtualForm->forceDelete();
            $data['success'] = true;
            $data['message'] = 'record deleted';
			\UserActivity::addToLog('deleted Form #'.$inputs['record_id'].' name: '.$VirtualForm->slug);
        }else{
            $data['success'] = false;
            $data['message'] = "record id or form slug is invalid";
        }


        return $data;
    }

    public function edit(){
        $data = [];
        $data['title'] = __('Edit Form');
        $data['form'] = \request('form_id');
        $data['form']->fields = json_decode($data['form']->fields,true);
        return view('dashboard.pages.form-builder.form', $data);
    }

    public function create(){
        $data = [];
        $data['title'] = __('New Form');
        return view('dashboard.pages.form-builder.form', $data);
    }

    public function update(Request $request){
        $data = [];

		$VirtualForm = \request('form_id');

	    $validation = [
            'notes' => 'required',
            'fields' => 'required|array',
		];

		foreach(\Config::get('app.languages') as $language){
			$prefix = $language->prefix;
			$validation['name_'.$prefix] = 'required';
		}

		$inputs = \Afrodien::validate($request,$validation);

		foreach(\Config::get('app.languages') as $language){
			$name_prefix = 'name_'.$language->prefix;
			$VirtualForm->$name_prefix = $inputs[$name_prefix];
		}

		$VirtualForm->notes      = $inputs['notes'];
        $VirtualForm->fields     = json_encode($inputs['fields']);
        $VirtualForm->update();
		$VirtualForm->fields     = $inputs['fields'];

		\FormBuilder::create($VirtualForm);

		\UserActivity::addToLog('updated Form #'.$VirtualForm->id);

        $data['success'] = true;
        $data['message'] = 'form updated successfully.';

        return json_encode($data);
    }

    public function store(Request $request){
        $data = [];
        $validation = [
            'notes' => 'required',
            'fields' => 'required|array'
        ];

		foreach(\Config::get('app.languages') as $language){
			$prefix = $language->prefix;
			$validation['name_'.$prefix] = 'required';
		}

		$inputs = \Afrodien::validate($request,$validation);

        $VirtualForm = new \App\VirtualForm();

		foreach(\Config::get('app.languages') as $language){
			$name_prefix = 'name_'.$language->prefix;
			$VirtualForm->$name_prefix = $inputs[$name_prefix];
		}

		$VirtualForm->notes      = $inputs['notes'];
        $VirtualForm->fields     = json_encode($inputs['fields']);
        $VirtualForm->save();


        $data['success'] = true;
        $data['message'] = 'Form created successfully.';
		$VirtualForm->fields     = $inputs['fields'];

		\FormBuilder::create($VirtualForm);

		\UserActivity::addToLog('added new Form #'.$VirtualForm->id);

        return json_encode($data);
    }

}
