<?php


namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Media;
use ImageOptimizer;

class MediaController extends Controller{


    public function uploadForm(){
		$data = [];
		$data['title'] = __('Media');
        return view('dashboard.pages.media.upload-form',$data);
    }

    public function thumbnail($image="wijEXisVD8zi80OS9ovJYTdYj1SeZX57.png",$width=450){
		$img = \Image::make(base_path().'/storage/app/public/images/original/'.$image);
        $img->encode('webp', 100)->resize($width, null, function ($constraint) {
            $constraint->aspectRatio();
        })->save(base_path().'/storage/app/public/images/thumbnail/'.$width.'/'.$image.'.webp');
		ImageOptimizer::optimize(base_path().'/storage/app/public/images/thumbnail/'.$width.'/'.$image.'.webp');
    }

    public function updateMedia(Request $request){
		$data = [];
		$validation = [];

		$validation['id'] = "required";
		$validation['name'] = "required";
		foreach(\Config::get('app.languages') as $language){
			$validation['title_'.$language->prefix] = "required";
			$validation['alt_'.$language->prefix] = "required";
		}

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled'),
			'extension.required' => __('Sorry, you can\'t change media extension')
		];

		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

		$inputs = $this->validate(request(), $validation,$validation_msgs);

		$Media = \App\Media::where('id', $inputs['id'])->first();

		$NewExt = \pathinfo($inputs['name'], \PATHINFO_EXTENSION);
		$OldExt = \pathinfo($Media->name, \PATHINFO_EXTENSION);


		if($NewExt!=$OldExt){
			$validation['extension']   = "required";
		}

		$inputs = $this->validate(request(), $validation,$validation_msgs);

		foreach(\Config::get('app.languages') as $language){
			$title = 'title_'.$language->prefix;
			$alt   = 'alt_'.$language->prefix;
			$Media->$title = $inputs[$title];
			$Media->$alt   = $inputs[$alt];
		}
		$Media->update();

		$data['message']   = "Media updated successfully";
		$data['success']   = true;

		return $data;
	}

    public function loadMore(Request $request){

		$data = [];
		$validation = [];

		$validation['page'] = "required";
		$validation['type'] = "required";

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];

		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

		$inputs = $this->validate(request(), $validation,$validation_msgs);

		$inputs['page']++;

		if($inputs['type']=='user'){
			$Media = \App\Media::where('created_by',\Auth::id())->paginate(12, ['*'], 'page', $inputs['page']);
		}else{
			$Media = \App\Media::paginate(12, ['*'], 'page', $inputs['page']);
		}
		$data['data'] = '';
		foreach($Media as $item){
			$data['data'] .= '<div class="thumbnail col-md-3" data-img="'.$item->name.'" data-id="'.$item->id.'"';
			foreach(\Config::get('app.languages') as $language){
				$data['data'] .= '
					data-title-'.$language->prefix.'="'.$item['title_'.$language->prefix].'"
					data-alt-'.$language->prefix.'="'.$item['alt_'.$language->prefix].'"
				';
			}
			$data['data'] .= '>';
			$data['data'] .= '<img src="'.asset('storage/images/thumbnail/300/'.$item->name.'.webp').'" />';
			$data['data'] .= '<i class="fas fa-check-square select_multimedia"></i>';
			$data['data'] .= '<i class="fas fa-pen-square edit_media" data-toggle="modal" data-target="#exampleModal"></i>';
			$data['data'] .= '</div>';
		}

		$data['lastPage'] = $Media->lastPage();
		$data['page']     = $inputs['page'];
		$data['success']  = true;

		return $data;
	}

    public function uploadSubmit(Request $request){

        $data            = [];
        $data['errors']  = [];
        $data['success'] = false;

		if(\Config::get('app.demo')==1){
			$data['success'] = false;
	        $data['message'] = __('Sorry, demo mode is enabled');
	        return $data;
		}


		$validation = [];
		$validation['file'] = 'required|mimes:'.\Config::get('upload.allowed.extensions').'|max:'.\Config::get('upload.max.filesize');
		$validation['type'] = 'required|in:image,multimedia,pdf-editor,image-editor,avatar,logo,logo-icon,favicon,pdf,defaultFeaturedImage';

		if(\request('type')=='pdf' || \request('type')=='pdf-editor'){
			$validation['file'] = 'required|mimes:pdf|max:'.\Config::get('upload.max.filesize');
		}

        $request->validate($validation);

		$file = $request->file('file');
		$Media = new \App\Media();
		$Media->extension = $file->getClientOriginalExtension();
		$Media->type      = \request('type');
		$Media->created_by   = \Auth::id();

		if($Media->type=='image' || $Media->type=='image-editor' || $Media->type=='multimedia'){
			$Media->name      = \Str::random(32).'.'.$Media->extension;
			$file->move(base_path('storage/app/public/images/original'), $Media->name);
			ImageOptimizer::optimize(base_path('storage/app/public/images/original/'.$Media->name));
			$Media->save();
			if($Media->extension=='mp4'){

			}else{
				$this->thumbnail($Media->name,100);
				$this->thumbnail($Media->name,300);
				$this->thumbnail($Media->name,450);
				$this->thumbnail($Media->name,600);
			}
		}elseif($Media->type=='pdf' || $Media->type=='pdf-editor'){
			$Media->name      = 'pdf-'.\Str::random(32).'.'.$Media->extension;
			$file->move(base_path().'/storage/app/public/pdf-files', $Media->name);
		}elseif($Media->type=='avatar'){
			$Media->name      = 'user-'.$Media->created_by.'.'.$Media->extension;
			$file->move(base_path().'/storage/app/public/users', $Media->name);
		}elseif($Media->type=='favicon'){
			$Media->name      = 'favicon.'.$Media->extension;
			$file->move(base_path().'/storage/app/public/', $Media->name);
		}elseif($Media->type=='defaultFeaturedImage'){
			$Media->name      = 'default-featured-image.'.$Media->extension;
			$file->move(base_path().'/storage/app/public/', $Media->name);
		}elseif($Media->type=='logo-icon'){
			$Media->name      = 'icon.'.$Media->extension;
			$file->move(base_path().'/storage/app/public/', $Media->name);
		}elseif($Media->type=='logo'){
			$Media->name      = 'logo.'.$Media->extension;
			$file->move(base_path().'/storage/app/public/', $Media->name);
		}

		\UserActivity::addToLog('uploaded new file: '.$Media->name);

        $data['file_name'] = $Media->name;
        $data['type']      = $Media->type;
        $data['extension'] = $Media->extension;
        $data['id']        = $Media->id;
        $data['url']       = url('storage/images/original/'.$Media->name);
        $data['message']   = "file uploaded successfully";
        $data['success']   = true;

        return $data;
    }

}
