<?php


namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\NewsLetter;
use Illuminate\Support\Facades\Mail;
use App\Traits\Afrodien;
use Validator;


class NewsLetterController extends Controller
{
	use Afrodien;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
		$data = [];
        $data['title'] = __('Send NewsLetter');
        return view('dashboard.pages.newsletter.index', $data);
    }

	public function send(){

		$data = [];

		$fields = [
			'title'        => 'required',
			'body'         => 'required'
		];

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$fields['demo']   = "required";
		}

		$inputs = $this->validate(request(), $fields, $validation_msgs);

		\DB::insert("insert into `newsletters_sent` set `title` = ? , `total_opened` = 0,  `body` = ? , `status` = 'inprogress', `at`= 0, `total_sent`= 0, `created_at` = ?  ",[$inputs['title'],\base64_encode($inputs['body']),\Carbon\Carbon::now()]);

		$data['success'] = true;
		$data['message'] = 'Email in progress';
		return $data;
	}

	public function verify(){
		$this->data['page'] = \App\Page::where('slug', '=', 'verify-newsletter')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->getMeta();

		$newsletter = new \App\NewsLetter();
		$newsletter = $newsletter::where('token',\request('token'))->first();
		if($newsletter){
			$newsletter->status = 'active';
			$newsletter->verified_at = date('Y-m-d H:i:s');
			$newsletter->update();
			$this->data['message'] = "Your eamil has been activated.";
		}else{
			$this->data['message'] = "invaild url";
		}
		return view('themes.'.\Config::get('app.theme').'.pages.verify-newsletter',$this->data);
	}

	
}
