<?php


namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


class SearchController extends Controller{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        $data = [];

        $data['title'] = __('Search');
        $data['pages'] = \App\Page::where('title_en', 'LIKE', '%'.\request('trim').'%')->get();
        $data['posts'] = \App\Post::where('post_title_en', 'LIKE', '%'.\request('trim').'%')->get();
        $data['categories'] = \App\PostCategory::where('category_title_en', 'LIKE', '%'.\request('trim').'%')->get();
        $data['tags'] = \App\PostTag::where('tag_title_en', 'LIKE', '%'.\request('trim').'%')->get();

        return view('dashboard.pages.search.index',$data);
    }

}
