<?php

namespace App\Http\Controllers\Dashboard\Support;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TicketsController extends Controller{

    public function listReportedMessages(){

		$title = __('Reported Messages');
		$messages = \App\SupportTicketMessage::with('user')->with('ticket')->where('note','!=','')->get();

		$data = [
			'title'  => $title,
			'messages' => $messages
		];

		return view('dashboard.pages.support.tickets.reported-messages',$data);

	}

    public function index(){

		$title = __('Tickets');
		$tickets = \App\SupportTicket::with('user')->with('department')->get();
		$data = [
			'title'  => $title,
			'tickets' => $tickets
		];

		return view('dashboard.pages.support.tickets.index',$data);

	}

	public function delete(){

		$data = [];
		$validation = [];
		$validation['ticket_id'] = 'required';


		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

		$inputs = $this->validate(request(), $validation,$validation_msgs);

		$ticket = \App\SupportTicket::where('id',$inputs['ticket_id'])->firstOrFail();
		$ticket->delete();

		\UserActivity::addToLog('deleted ticket.');

		$data['success'] = true;
		$data['message'] = 'ticket deleted';

		return $data;
	}

	public function close(){

		$data = [];
		$validation = [];
		$validation['ticket_id'] = 'required';


		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

		$inputs = $this->validate(request(), $validation,$validation_msgs);



		$ticket = \App\SupportTicket::where('id',$inputs['ticket_id'])->where('status','!=','closed')->first();

		if($ticket){
			$ticket->status = 'closed';
			$ticket->update();

			\UserActivity::addToLog('closed ticket.');

			$data['success'] = true;
			$data['message'] = 'ticket closed';
		}else{
			$data['success'] = false;
			$data['message'] = 'Error, may be ticket is closed';
		}
		return $data;

	}

	public function reply(){
		$data = [];

		$validation = [];
		$validation['message']   = "required";
		$validation['completed'] = "";
		$validation['ticket_id'] = "required";


		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

		$inputs = $this->validate(request(), $validation,$validation_msgs);


		$ticket = \App\SupportTicket::where('ticket_uuid',$inputs['ticket_id'])->where('status','!=','closed')->firstOrFail();
		if($ticket){
			if($inputs['completed']=="true"){
				$ticket->status       = 'completed';
				$ticket->completed_at = date('Y-m-d H:i:s');
			}else{
				$ticket->status      = 'inprogress';
			}
			$ticket->update();
		}

		$message = new \App\SupportTicketMessage();
		$message->ticket_uuid = $inputs['ticket_id'];
		$message->message     = $inputs['message'];
		$message->created_by   = \Auth::user()->id;
		$message->save();

		\UserActivity::addToLog('added new reply on ticket.');

		$data['success'] = true;
		$data['message'] = 'reply added';

		return $data;
	}

	public function view($ticket_id){

		$title = __('View Ticket');

		$ticket = \App\SupportTicket::with('messages')->where('id', $ticket_id)->firstOrFail();
		$data = [
			'title' => $title,
			'ticket' => $ticket
		];

		return view('dashboard.pages.support.tickets.view',$data);

	}

	public function create(){

		$title = __('Create Ticket');

		$departments = \DB::table('support_departments')->get();
		$departments->each(function($department){
			$name = 'name_'.\Config::get('app.locale');
			$department->name = $department->$name;
		});

		$data = [
			'title' => $title,
			'departments' => $departments
		];

		return view('dashboard.pages.support.tickets.create',$data);

	}

	public function store(){
		$data = [];

		$validation = [];
		$validation['Title']      = "required";
		$validation['User']       = "required";
		$validation['Status']     = "required";
		$validation['Content']    = "required";
		$validation['Department'] = "required";

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

        $inputs = $this->validate(request(), $validation,$validation_msgs);

		$ticket = new \App\SupportTicket();
		$ticket->user_id       = $inputs['User'];
		$ticket->created_by     = \Auth::user()->id;
		$ticket->status        = $inputs['Status'];
		$ticket->title         = $inputs['Title'];
		$ticket->department_id = $inputs['Department'];
		$ticket->ticket_uuid   = \Str::uuid();
		$ticket->save();

		$message = new \App\SupportTicketMessage();
		$message->ticket_uuid = $ticket->ticket_uuid;
		$message->message     = $inputs['Content'];
		$message->created_by   = \Auth::user()->id;
		$message->save();



		\UserActivity::addToLog('Created new ticket.');

		$data['success'] = true;
		$data['message'] = 'Ticket Created';

		return $data;
	}

}
