<?php

namespace App\Http\Controllers\Dashboard\Surveys;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SurveyController extends Controller{


    public function reports($id){
		$data = [];
        $data['title'] = __('Surveys');
		$Survey = new \App\Survey();
		$data['Survey'] = $Survey->find($id);


		$data['submissions'] = \DB::table('surveys_submission')->where('survey_id',$id)->get();

        return view('dashboard.pages.surveys.index',$data);
    }

	public function delete(Request $request){
		$data = [];

		$validation = [
			'record_id' => 'required',
		];

		$inputs = \Afrodien::validate($request,$validation);

		$Survey = \DB::table('surveys_submission')->where('id', $inputs['record_id'])->delete();
		if($Survey){
			$data['success'] = true;
			$data['message'] = 'record deleted';
			\UserActivity::addToLog('deleted Survey #'.$inputs['record_id']);
		}else{
			$data['success'] = false;
			$data['message'] = "record id is invalid";
		}
		return $data;
	}


}
