<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App;
use App\VirtualSystem;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use App\Traits\VirtualSystemViewer;
use Illuminate\Support\Facades\Schema;


class VirtualSystemController extends Controller{

	use VirtualSystemViewer;

	public $validation = [];
	public $relations = [];
	public $multimedia = [];
	public $data = [];

    public function index(Request $request, $page_slug){
        $data = [];
        $VirtualSystem = VirtualSystem::where('slug','=',$page_slug)->firstOrFail();
        $VirtualSystem->fields = json_decode($VirtualSystem->fields,true);
        $data['title'] = $VirtualSystem['title_'.\Config::get('app.locale')];
        $data['system'] = $VirtualSystem;
        $data['data'] = \DB::select('select * from `'.$VirtualSystem['table'].'` ', []);
        $data['data'] = collect($data['data'])->map(function($x){ return (array) $x; })->toArray();
        return view('dashboard.pages.virtual-system.index',$data);
    }

    public function data(Request $request, $system_name){

        $data = \VirtualSystem::initialDatatable($request);

        $System = VirtualSystem::where('slug','=',$system_name)->first();
        if($System){

			$System['fields'] = json_decode($System['fields'],true);
            $System['operations'] = explode(',',$System['operations']);
            $System['operations'] = array_map("trim",$System['operations']);

			$query = \DB::table($System->table);
			$values = [];
			$relations = [];
			$_fields = [];
			$SelectFields = [];
			foreach($System['fields'] as $field){
				if($field['display']==1){
					if($field['has_relation']==1){
						if($field['relation']['type']=='one'){
							$query->leftJoin(
								$field['relation']['table'],
								$field['relation']['table'].'.'.$field['relation']['key'],
								'=',
								$System->table.'.'.$field['name']
							);

							if(isset($field['multi_languages']) && $field['multi_languages']==1){
								$SelectFields[] = $field['relation']['table'].'.'.substr($field['relation']['show'],0,-2).\Config::get('app.locale').' as '.$field['relation']['table'].'_'.substr($field['relation']['show'],0,-2).\Config::get('app.locale');
							}else{
								$SelectFields[] = $field['relation']['table'].'.'.$field['relation']['show'].' as '. $field['relation']['table'].'_'.$field['relation']['show'];
							}

						}else{
							$key1 = \SystemBuilder::createKey($System->table);
							$key2 = \SystemBuilder::createKey($field['relation']['table']);
							$fake_table = $field['name'].'_'.$System->table.'_'.$field['relation']['table'].'_r';

							$query->leftJoin(
								$fake_table,
								$System->table.'.'.$System->key,
								'=',
								$fake_table.'.'.$key1
							);

							$query->leftJoin(
								$field['relation']['table'],
								$field['relation']['table'].'.'.$field['relation']['key'],
								'=',
								$fake_table.'.'.$key2
							);

							if(isset($field['multi_languages']) && $field['multi_languages']==1){
								$SelectFields[] = $field['relation']['table'].'.'.substr($field['relation']['show'],0,-2).\Config::get('app.locale').' as '.$field['relation']['table'].'_'.substr($field['relation']['show'],0,-2).\Config::get('app.locale');
							}else{
								$SelectFields[] = $field['relation']['table'].'.'.$field['relation']['show'].' as '.$field['relation']['table'].'_'.$field['relation']['show'];
							}

						}
						if(isset($field['multi_languages']) && $field['multi_languages']==1){
							$_fields[] = $field['relation']['table'].'_'.substr($field['relation']['show'],0,-2).\Config::get('app.locale');
						}else{
							$_fields[] = $field['relation']['table'].'_'.$field['relation']['show'];
						}
						$relations[$field['relation']['show']] = $field['relation'];
					}elseif(isset($field['multi_languages']) && $field['multi_languages']==1){
						$_fields[] = $field['name'].'_'.\Config::get('app.locale');
					}elseif($field['type']=="options"){
						$_fields[] = $field['name'];
						$values[$field['name']] = $field['values'];
					}else{
						$_fields[] = $field['name'];
					}
				}
			}
			$SelectFields[] = $System->table.'.*';
			$query->select($SelectFields);

			$filtered = clone $query;

			if($request->get('order')[0]['column']==0){
				$filtered->orderBy($System->table.'.'.$System->key,$request->get('order')[0]['dir']);
			}
			if(!empty($request->get('columns')[0]['search']['value'])){
				$filtered->orWhere($System->table.'.'.$System->key,'like','%'.$request->get('columns')[0]['search']['value'].'%');
			}

			foreach($_fields as $i => $field){
				if(isset($relations[$field])){
					$_field = $relations[$field]['table'].'.'.$field;
				}else{
					$_field = $System->table.'.'.$field;
				}
				if(!empty($request->get('columns')[$i+1]['search']['value'])){
					$filtered->orWhere($_field,'like','%'.$request->get('columns')[$i+1]['search']['value'].'%');
				}
				if(!empty($request->get('search')['value'])){
					$filtered->orWhere($_field,'like','%'.$request->get('search')['value'].'%');
				}
				if($request->get('order')[0]['column']==$i+1){
					$filtered->orderBy($_field,$request->get('order')[0]['dir']);
				}
			}

			$totalfiltered = clone $filtered;

			$rows = $filtered->skip($data['start'])->take($data['length'])->get();

			$data['recordsTotal'] = $query->count();
	        $data['recordsFiltered'] = $totalfiltered->count();

			foreach($rows as $row){
				$_row = [];

				$system_key = $System['key'];
				$_row[] = $row->$system_key;

				foreach($_fields as $field){
					if(isset($values[$field])){
						$_row[] = isset($values[$field][$row->$field]) ? $values[$field][$row->$field]['label'][\Config::get('app.locale')] : '';
					}else{
						$_row[] = $row->$field;
					}
				}

				$operations = \VirtualSystem::getOperations($System['slug'],$System['operations'],$row->$system_key);


				$ClassName = 'App\\'.Str::studly(Str::singular($System['slug']));
				if (class_exists($ClassName)) {
					$M = new $ClassName();
					if(method_exists($M,'operations')){
						$operations .=  $M->operations($row->$system_key);
					}
				}

				$_row[] = $operations;

				$data['data'][] =  $_row;
			}

        }else{
			$data['error'] = "system name is not exist.";
		}

        return json_encode($data);
    }

    public function store(Request $request, $type){
        $this->data = [];
        $this->validation = [];

        $VirtualSystem = VirtualSystem::where('slug','=',$request->page_slug)->first();
		if($VirtualSystem){
			$VirtualSystem->fields = json_decode($VirtualSystem->fields,true);

			$item = new \App\DynamicModel;
			$item->setSystem($VirtualSystem);

			$this->relations = [];
			$this->multimedia = [];

			$this->setFields($VirtualSystem,$item,'store');

			$inputs = \Afrodien::validate($request,$this->validation);

			if (Schema::hasColumn($VirtualSystem->table, 'created_by')) {
				$item->created_by = Auth::user()->id;
			}

			$item->save();

			$this->setMultimedia($this->multimedia,$VirtualSystem,$item);
			$this->setRelations($this->relations,$VirtualSystem,$item);

			\UserActivity::addToLog('Added new record #'.$item->id.' at '.$VirtualSystem->table);

			$this->data['message'] = __("record inserted successfully");
			$this->data['success'] = true;

		}else{
			$this->data['success'] = false;
			$this->data['message'] = __("Error, system not found.");
		}

        return $this->data;
    }

    public function update(Request $request){

		$this->data = [];

		$VirtualSystem = VirtualSystem::where('slug','=',$request->page_slug)->first();
		if($VirtualSystem){

			$VirtualSystem->fields = json_decode($VirtualSystem->fields,true);

			$item = new \App\DynamicModel;
			$item->setSystem($VirtualSystem);

			$item = $item->where($VirtualSystem->key,$request->record_id)->firstOrFail();

			$this->relations = [];
			$this->multimedia = [];

			$this->setFields($VirtualSystem,$item,'update');

			$inputs = \Afrodien::validate($request,$this->validation);

			$item->update();

			$this->setMultimedia($this->multimedia,$VirtualSystem,$item);
			$this->setRelations($this->relations,$VirtualSystem,$item);

			\UserActivity::addToLog('updated record #'.$item->id.' at '.$VirtualSystem->table);

			$this->data['message'] = __("record updated successfully");
			$this->data['success'] = true;

		}else{
			$this->data['success'] = false;
			$this->data['message'] = __("Error, system not found.");
		}

        return $this->data;
    }

    public function delete(Request $request){
        $data = [];

        $validation = [
			'record_id' => 'required',
			'system' => 'required'
		];

		$inputs = \Afrodien::validate($request,$validation);


		$VirtualSystem = VirtualSystem::where('slug','=',$inputs['system'])->firstOrFail();


		$item = new \App\DynamicModel;
		$item->setSystem($VirtualSystem);
		$item = $item->where($VirtualSystem->key,$request->record_id)->firstOrFail();
		$item->forceDelete();
		\UserActivity::addToLog('deleted record #'.$inputs['record_id'].' at '.$VirtualSystem->slug);

        $data['success'] = true;
        $data['message'] = __('record deleted successfully');
        return $data;
    }

    public function basedOn(Request $request){
		$data = [];

		$validation = [
			'table' => 'required',
			'where' => 'required',
			'by' => 'required',
			'value' => 'required'
		];

		$inputs = \Afrodien::validate($request,$validation);

		$columns = \DB::select("select * from `".$inputs['table']."` where `".$inputs['where']."` = '".$inputs['value']."' and `".$inputs['by']."` like '%".\request('search')."%'  ");
		foreach ($columns as $column){
			$row = [];
			$field_name = $inputs['by'];
			$row['id'] = $column->id;
			$row['text'] = $column->$field_name;
			$data['results'][] = $row;
		}
		return $data;
	}

    public function edit(Request $request){
        $data = [];

        $data['system'] = VirtualSystem::where('slug','=',$request->page_slug)->firstOrFail();
		$data['title'] = $data['system']['title_'.\Config::get('app.locale')];
        $data['system']->fields = json_decode($data['system']->fields,true);

		$item = new \App\DynamicModel;
		$item->setSystem($data['system']);
		$data['record'] = $item->where($data['system']->key,$request->record_id)->firstOrFail();
        return view('dashboard.pages.virtual-system.form', $data);
    }

    public function create(Request $request){
        $data = [];
        $data['system'] = VirtualSystem::where('slug','=',$request->page_slug)->firstOrFail();
        $data['system']->fields = json_decode($data['system']->fields,true);
        $data['title'] = $data['system']['title_'.\Config::get('app.locale')];
        return view('dashboard.pages.virtual-system.form', $data);
    }

}
