<?php

namespace App\Http\Controllers\FrontEnd;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\Afrodien;

class BlogController extends Controller{

	use Afrodien;


	public function __construct(){
		$this->prepareViewer();
    }

	public function index(){
		$this->data['page'] = \App\Page::where('slug', '=', 'blog')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->getMeta();
		$this->aside();
		$this->data['posts'] = \App\Post::active()->with('user')->has('not_isolated_category')->latest('updated_at')->paginate(\Config::get('app.itemsPerPage'));
	    return view('themes.'.\Config::get('app.theme').'.pages.blog',$this->data);
	}

	public function aside(){

		$this->data['latestPosts'] = \App\Post::active()->with('category')->latest()->limit(3)->get();
		$this->data['latestPosts']->each(function($post){
			$post->structure();
		});

		$this->data['popularCategories'] = \App\PostCategory::active()->whereIn('category_id',explode(',',\Config::get('app.popular.categories')))->limit(5)->get();
		$this->data['popularCategories']->each(function($category){
			$category->structure();
		});

		$this->data['trendingTags'] = \App\PostTag::whereIn('tag_id',explode(',',\Config::get('app.popular.tags')))->limit(5)->get();;
		$this->data['trendingTags']->each(function($tag){
			$tag->structure();
		});

	}


	public function viewCategory($slug){
		$this->data['category'] = \App\PostCategory::active()->where('category_slug', '=', $slug)->with('posts')->first();
		if ($this->data['category']) {
			$this->aside();
			$this->data['category']->structure();
			$this->data['posts'] = $this->data['category']->posts()->active()->latest()->paginate(\Config::get('app.itemsPerPage'));
			$this->data['title'] = $this->data['category']['title'];
			$this->view = "themes.".\Config::get('app.theme').".pages.blog";
			if($this->data['category']['is_custom']==1){
				$this->view = "themes.".\Config::get('app.theme').".pages.".$this->data['category']['category_slug'];
			}
		}


		$this->getMeta();
		if(isset($this->view)){
			return view($this->view,$this->data);
		}

		return $this->data;

	}



	public function viewSearch($term){
		$this->aside();
		$this->data['page'] = Page::active()->where('slug', '=', 'search')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->data['posts'] = \App\Post::active()->where('post_title_'.\App::getLocale(),'like','%'.$term.'%')->with('user')->paginate(\Config::get('app.itemsPerPage'));
		$this->getMeta();
		return view("themes.".\Config::get('app.theme').".pages.search",$this->data);
	}

	public function viewPost(Request $request ,$category_slug,$post_slug){
		$this->data['post'] = \App\Post::active()->with('user','comments','category')->whereHas(
			'category', function ($query) use ($category_slug) {
				return $query->where('category_slug', '=', $category_slug);
			})->where([
				'post_slug' => $post_slug,
			])->first();
		if($this->data['post']){
			$this->data['post']->structure();
			$this->data['post']['category']->structure();
			$this->data['title'] = $this->data['post']['title'];


			preg_match_all('#\[gallery\](.*?)\[\/gallery\]#is', $this->data['post']['content'], $matches);
			foreach ($matches[0] as $i => $value) {
				$Gallery = \App\Album::where('id', $matches[1][$i])->first();
				$Conten = '<div class="owl-carousel">';
				if($Gallery){
					foreach ($Gallery->media() as $media) {
						$Conten .= '<a class="venobox" href="'.$media['src'].'">';
						if(isset($media['type']) && $media['type'] == "image/webp"){
							$Conten .= '<img src="'.$media['src'].'" />';
						}else{
							$Conten .= '<video width="100%" height="100%" controls> <source src="'.$media['src'].'" type="video/mp4"> Your browser does not support the video tag. </video>';
						}
						$Conten .= '</a>';
					}
				}
				$Conten .= '</div>';

				$this->data['post']['content'] = \str_replace($value,$Conten, $this->data['post']['content']);
			}


			$this->aside();
			$this->getMeta();
			return view("themes.".\Config::get('app.theme').".pages.post",$this->data);
		}
	}

	public function viewTag($slug){
		$this->aside();
		$this->data['tag']   = \App\PostTag::where('tag_slug', $slug)->with('posts')->firstOrFail();
		$this->data['tag']->structure();
		$this->data['posts'] = $this->data['tag']->posts()->active()->paginate(\Config::get('app.itemsPerPage'));
		$this->data['title'] = $this->data['tag']['title'];
		$this->getMeta();
		return view("themes.".\Config::get('app.theme').".pages.blog",$this->data);
	}

}
