<?php

namespace App\Http\Controllers\FrontEnd;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Config;
use App\Http\Controllers\Controller;

class CommentController extends Controller{

    public function submit(){
		$data = [];

		$validation = [];
		if(!\Auth::check()){
			$validation['name']    = "required";
			$validation['email']   = "required|email";
		}
		$validation['comment'] = "required";
		$validation['post_id'] = "required";

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

        $inputs = $this->validate(request(), $validation,$validation_msgs);

		$Comment = new \App\Comment();
		$Comment->body = $inputs['comment'];
		$Comment->post_id = $inputs['post_id'];
		if(\Auth::check()){
			$User = \Auth::user();
			$Comment->name = '';
			$Comment->email = '';
			$Comment->user_id = $User->id;
			$Comment->status = 'published';
		}else{
			$Comment->name = $inputs['name'];
			$Comment->email = $inputs['email'];
			$Comment->status = 'awaiting-approval';
		}
		$Comment->save();

		$data['success'] = true;
		$data['message'] = 'Thank you ... we will post your comment soon.';

        return $data;
    }
}
