<?php

namespace App\Http\Controllers\FrontEnd;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Config;
use App\Http\Controllers\Controller;

class ContactController extends Controller{

    public function submit(){
		$data = [];

		$validation = [];
		$validation['name']    = "required";
		$validation['email']   = "required|email";
		$validation['phone']   = "";
		$validation['subject'] = "required";
		$validation['message'] = "required";

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

        $data = $this->validate(request(), $validation,$validation_msgs);

		$Message = "
			Name : ".$data['name']."
			Email : ".$data['email']."
			Phone : ".$data['phone']."
			Subject : ".$data['subject']."
			Message : ".$data['message']."

		";

		$stream = imap_open(
			"{".\Config::get('mail.mailers.imap.host').":".\Config::get('mail.mailers.imap.port')."}INBOX",
			\Config::get('app.contact.credential.email'), \Config::get('app.contact.credential.password')
		);

		if($stream){

	        $append=imap_append($stream, "{".\Config::get('mail.mailers.imap.host').":".\Config::get('mail.mailers.imap.port')."}INBOX"
	            , "From: ".$data['email']."\r\n"
	            . "To: ".\Config::get('app.contact.credential.email')."\r\n"
	            . "Subject: Msg From Contact Page\r\n"
	            . "Date: ".date(" Y-m-d H:i:s")."\r\n"
	            . "\r\n"
	            . $Message."\r\n"
	        );

	        if(!$append){
	            $data['message']="Some thing went error.";
	        }

	        imap_close($stream);

			\Mail::send('emails.ThankYouConatctMail', [], function ($message) use ($Message,$data){
				$message->to($data['email'], $data['name']);
				$message->from(\Config::get('app.contact.credential.email'));
				$message->setSubject("Thank you for contacting us!");
			});

			$data['success'] = true;
			$data['message'] = 'Thank you for contacting us. You are very important to us, all information received will always remain confidential. We will contact you as soon as we review your message.';

	    }else{
			$data['success'] = false;
			$data['message'] = 'The server suffers from a lot of pressure, try later.';
		}

        return $data;
    }
}
