<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;


class NewsLetterController extends Controller{

	public function submit(){
		$data = [];

		$newsletter = new \App\NewsLetter();
		$newsletter = $newsletter::where('email',\request('newsletter_email'))->first();
		if($newsletter && $newsletter->status =='inactive'){
			\Mail::to($newsletter->email)->send(new \App\Mail\VerifyNewsletterMail(
				$newsletter->name,
				$newsletter->email,
				$newsletter->token
			));
			$data['success'] = true;
			$data['message'] = 'Thanks! Check your email to accept newsletter!';
			return $data;
		}

		$validation = [];
		$validation['newsletter_name']    = "required";
		$validation['newsletter_email']   = "required|email|unique:newsletter_subscribers,email";

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

        $inputs = $this->validate(request(), $validation,$validation_msgs);

		$visitor_id = \Cookie::get('visitor_id');

		$NewsLetter = new \App\NewsLetter();
		$NewsLetter->name = $inputs['newsletter_name'];
		$NewsLetter->email = $inputs['newsletter_email'];
		$NewsLetter->visitor_id = $visitor_id;
		$NewsLetter->token = \Str::uuid();
		$NewsLetter->user_id = (\Auth::check()) ? \Auth::id() : 0;
		$NewsLetter->status = 'inactive';
		\Mail::to($NewsLetter->email)->send(new \App\Mail\VerifyNewsletterMail(
			$NewsLetter->name,
			$NewsLetter->email,
			$NewsLetter->token
		));
		$NewsLetter->save();



		$data['success'] = true;
		$data['message'] = 'Thanks! Check your email to accept newsletter!';

        return $data;
    }



}
