<?php

namespace App\Http\Controllers\FrontEnd;

use Illuminate\Http\Request;
use App;
use App\Page;
use Illuminate\Support\Facades\Artisan;
use App\Traits\Afrodien;
use App\Http\Controllers\Controller;


class ServiceController extends Controller{

	use Afrodien;

	public $data = [];

	public function __construct(){
		$this->prepareViewer();
	}

	public function index(){
		$this->data['page'] = \App\Page::where('slug', '=', 'services')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->data['services'] = \App\Service::latest()->paginate(\Config::get('app.itemsPerPage'));
		$this->data['services']->each(function($service){
			$service->structure();
		});
		$this->getMeta();
		return view('themes.'.\Config::get('app.theme').'.pages.services',$this->data);
	}

	public function view(Request $request,$category,$slug){
		$this->data['service'] = \App\Service::where('slug',$slug)->first();
		if($this->data['service']){
			$this->data['service']->structure();
			$this->data['title'] = $this->data['service']['title'];
			$this->getMeta();
			return view('themes.'.\Config::get('app.theme').'.pages.service',$this->data);
		}
	}

}
