<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class VirtualFormController extends Controller{

    public function submit(Request $request){
        $this->data = [];
        $this->validation = [];

        $VirtualForm = \App\VirtualForm::where('id','=',$request->form_id)->first();
		if($VirtualForm){
			$VirtualForm->fields = json_decode($VirtualForm->fields,true);

			$item = new \App\DynamicModel;
			$item->setVirtualForm($VirtualForm);

			foreach($VirtualForm->fields as $field){
				$this->validation[$field['name']] = $this->setValidation($field,$VirtualForm);
			}

			$inputs = \Afrodien::validate($request,$this->validation);

			foreach($VirtualForm->fields as $field){
				$prefix = $field['name'];
				$item->$prefix = $inputs[$prefix];
			}

			$item->save();

			$this->data['message'] = __("record inserted successfully");
			$this->data['success'] = true;

		}else{
			$this->data['success'] = false;
			$this->data['message'] = __("Error, system not found.");
		}

        return $this->data;
    }


	static function setValidation($field,$VirtualSystem){

		$_validation = [];

		if ($field['is_required'] == "1") {
			$_validation[] = 'required';
		}

		if ($field['type'] == "email") {
			$_validation[] = 'email';
		}

		if ($field['type'] == "number") {
			$_validation[] = 'numeric';
		}

		if ($field['type'] == "options") {
			$options = [];
			foreach($field['values'] as $option){
				$options[] = $option['name'];
			}
			$_validation[] = 'in:'.implode(',',$options);
		}

		if ($field['unique'] == "1") {
			$_validation[] = 'unique:form_' . $VirtualSystem->id;
		}

		$_validation = implode("|", $_validation);

		return $_validation;
	}



}
