<?php

namespace App\Http\Controllers\Sitemap;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SitemapController extends Controller{

	public $PerPage = 500;
	public $data = [];

    public function index(){
		$this->data['page']        = \App\Page::active()->orderBy('updated_at', 'desc')->first();
		$this->data['pageCounter'] = (int) ceil(\App\Page::active()->orderBy('updated_at', 'desc')->count()/$this->PerPage);

		$this->data['post']        = \App\Post::active()->orderBy('updated_at', 'desc')->first();
		$this->data['postCounter'] = (int) ceil(\App\Post::active()->orderBy('updated_at', 'desc')->count()/$this->PerPage);

		$this->data['category']        = \App\PostCategory::active()->orderBy('updated_at', 'desc')->first();
		$this->data['categoryCounter'] = (int) ceil(\App\PostCategory::active()->orderBy('updated_at', 'desc')->count()/$this->PerPage);

		$this->data['tag']        = \App\PostTag::orderBy('updated_at', 'desc')->first();
		$this->data['tagCounter'] = (int) ceil(\App\PostTag::orderBy('updated_at', 'desc')->count()/$this->PerPage);

		return response()->view('sitemap.index',$this->data)->header('Content-Type', 'text/xml');
    }

	public function pages(){
	    $this->data['pages'] = \App\Page::active()->simplePaginate($this->PerPage);
	    return response()->view('sitemap.pages',$this->data)->header('Content-Type', 'text/xml');
	}

	public function posts(){
	    $this->data['posts'] = \App\Post::active()->simplePaginate($this->PerPage);
	    return response()->view('sitemap.posts',$this->data)->header('Content-Type', 'text/xml');
	}

	public function categories(){
	    $this->data['categories'] = \App\PostCategory::active()->simplePaginate($this->PerPage);
	    return response()->view('sitemap.categories',$this->data)->header('Content-Type', 'text/xml');
	}

	public function tags(){
	    $this->data['tags'] = \App\PostTag::simplePaginate($this->PerPage);
	    return response()->view('sitemap.tags',$this->data)->header('Content-Type', 'text/xml');
	}

}
