<?php

namespace App\Http\Middleware;

use Closure;

class Checker
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
    */

    public function handle($request, Closure $next){

		$host = $request->header('host');

		$url = $request->url();
		$reditectTo = new \App\Redirection();
		$url = $reditectTo->where('url', $url)->first();
		if($url){
			return \Redirect::to($url->redirect_to, 301);
		}


		$full_url = $request->fullUrl();
		$reditectTo = new \App\Redirection();
		$full_url = $reditectTo->where('url', $full_url)->first();
		if($full_url){
			return \Redirect::to($url->$full_url, 301);
		}


		if(\Config::get('app.www')=='true'){
		    if (substr($host, 0, 4) != 'www.') {
				$request->headers->set('host', 'www.' . $host);
				return \Redirect::to($request->fullUrl(),301);
		    }
		}else{
			if (substr($host, 0, 4) === 'www.') {
				$request->headers->set('host', substr($host, 4));
				return \Redirect::to($request->fullUrl(),301);
		   }
		}

		if(\Config::get('app.https')=='true'){
			if(!$request->secure()){
                return redirect()->secure($request->getRequestUri());
            }
        }

        return $next($request);
    }

}
