<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\response;

class Tracker{

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
    */

	public function handle($request, Closure $next){

		$response = $next($request);

		if(!$request->wantsJson()){
			if($request->route()->getPrefix()!='/dashboard'){
				$data = $this->getDataFromResponse($response);
				if($request->route()->getName()=='frontend.search'){
					\Tracker::addToReport('search',\request('search_term'));
					\Tracker::addToSearchReport();
				}elseif(isset($data['category'])){
					\Tracker::addToReport('category',$data['category']['category_id']);
				}elseif(isset($data['post'])){
					\Tracker::addToReport('post',$data['post']['post_id']);
				}elseif(isset($data['tag'])){
					\Tracker::addToReport('tag',$data['tag']['tag_id']);
				}elseif(isset($data['page'])){
					\Tracker::addToReport('page',$data['page']['id']);
				}else{
					\Tracker::addToReport('page',0);
				}
			}
		}
		return $response;
	}

	protected function getDataFromResponse($response)
	{
	    $content = $response->getOriginalContent();
	    return is_object($content) ? $content->getData() : [] ;
	}
}
