<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;

class Page extends Model
{

	use Afrodien;


	public function slider(){
        return $this->belongsTo(Slider::class)->with('slides');
    }

	public function url(){
		return isset($this['slug']) ? route('frontend.page',['page_slug'=>$this->slug]) : "";
	}

	public function structure(){
		$Locale = \App::getLocale();
		$this['title']         = isset($this['title_'.$Locale]) ? $this['title_'.$Locale] : "";
		$this['description']   = isset($this['description_'.$Locale]) ? $this['description_'.$Locale] : "";
		$this['content']       = isset($this['content_'.$Locale]) ? \base64_decode($this['content_'.$Locale]) : "";
		$this['featuredImage'] = $this->getFeaturedImage();
	}

	public function getFeaturedImage(){
		if(isset($this->featured_image) && !empty($this->featured_image) && \file_exists(storage_path().'/images/original/'.$this->featured_image)){
			$image = $this->image('images/original/',$this->featured_image);
		}else{
			$image = $this->image('',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

	public function scopeActive($query) {
		return $query->where('status', 'published');
	}

}
