<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;


class PostTag extends Model
{

	use Afrodien;

	protected $table = 'posts_tags';


	protected $primaryKey = 'tag_id';

    public function getRouteKeyName(){
        return 'tag_slug';
    }


	public function posts(){
		return $this->belongsToMany(Post::class,'post_tags_posts_posts_tags_r','post_tag_id','post_id');
	}

	public function url(){
		return isset($this['tag_slug']) ? route('frontend.blog.tag',['tag_slug'=>$this->tag_slug]) : "";
	}

	public function getFeaturedImage(){
		if(isset($this->tag_featured_image) && !empty($this->tag_featured_image) && \file_exists(storage_path().'/images/original/'.$this->tag_featured_image)){
			$image = $this->image('/images/original/',$this->tag_featured_image);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}


	public function structure(){
        $Locale = \App::getLocale();
        $this['title']       = isset($this['tag_title_'.$Locale]) ? $this['tag_title_'.$Locale] : "";
        $this['description'] = isset($this['tag_description_'.$Locale]) ? $this['tag_description_'.$Locale] : "";
        $this['content']     = isset($this['tag_content_'.$Locale]) ? \base64_decode($this['tag_content_'.$Locale]) : "";
		$this['featuredImage'] = $this->getFeaturedImage();
		$this['url']           = $this->url();
    }


}
