<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Notifications\Messages\MailMessage;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {


        $visitor_id = \Cookie::get('visitor_id');
		if($visitor_id===null){
            \Tracker::registerVisitor();
		}

		\Schema::defaultStringLength(191);

		if (\Schema::hasTable('configs')) {

	        $settings = \App\Config::all(['name','value']);
	        foreach ($settings as $setting){
	            \Config::set($setting->name, $setting->value);
	        }
	        \Config::set('app.nav', json_decode(\Config::get('app.nav'),true));
	        \Config::set('app.name', json_decode(\Config::get('app.name'),true));
	        \Config::set('app.languages', json_decode(\Config::get('app.languages')),true);
	        \Config::set('app.copyright', json_decode(\Config::get('app.copyright'),true));
	        \Config::set('app.cookie.text', json_decode(\Config::get('app.cookie.text'),true));
	        \Config::set('app.slogan', json_decode(\Config::get('app.slogan'),true));
			\Config::set('app.customer-area.title', json_decode(\Config::get('app.customer-area.title'),true));
	        \Config::set('app.description', json_decode(\Config::get('app.description'),true));
	        \Config::set('mail.from.name', \Config::get('app.name')[\Config::get('app.locale')]);

	        \Config::set('app.ad.auto', base64_decode(\Config::get('app.ad.auto')));
	        \Config::set('app.ad.footer', base64_decode(\Config::get('app.ad.footer')));
	        \Config::set('app.ad.header', base64_decode(\Config::get('app.ad.header')));

	        \Config::set('app.body.html', base64_decode(\Config::get('app.body.html')));
	        \Config::set('app.head.html', base64_decode(\Config::get('app.head.html')));

	        \Config::set('app.contact.map', base64_decode(\Config::get('app.contact.map')));
	        \Config::set('mlh.map', base64_decode(\Config::get('mlh.map')));
	        \Config::set('hok.map', base64_decode(\Config::get('hok.map')));
		}
    }
}
