<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;


class Service extends Model
{

	use Afrodien;


    // Set mass-assignable fields
    protected $fillable = ['title', 'content', 'category', 'slug'];
	protected $primaryKey = 'id';

    /**
     * Get the route key for the model.
     *
     * @return string
     */
    public function getRouteKeyName()
    {
        return 'slug';
    }

	public function scopeActive($query) {
	    return $query->where('status', 'published')->where('title_'.\Config::get('app.locale'), '!=', '');
	}

	public function category(){
		return $this->belongsTo("App\PostCategory",'category_id');
    }

	public function not_isolated_category(){
		return $this->category()->where('isolate','!=','1');
    }

    public function user()
    {
		return $this->belongsTo("App\User",'user_id');
    }

	public function thumbnail($Quality=100){
		if(
			isset($this->featured_image) && !empty($this->featured_image)
		 	&& \file_exists(storage_path('app/public/images/thumbnail/'.$Quality.'/',$this->featured_image.'.webp'))
		 	&& \is_file(storage_path('app/public/images/thumbnail/'.$Quality.'/',$this->featured_image.'.webp'))
	 	){
			$image = $this->image('/images/thumbnail/'.$Quality.'/',$this->featured_image.'.webp');
		}else{
			$image = $this->getFeaturedImage();
		}
		return $image;
	}

	public function getFeaturedImage(){
		if(isset($this->featured_image) && !empty($this->featured_image) && \file_exists(storage_path('app/public/images/original/'.$this->featured_image))){
			$image = $this->image('/images/original/',$this->featured_image);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

	public function url(){
		return (isset($this->slug) && !empty($this->slug)) ? \route('frontend.services.view', ['slug' => $this->slug]) : "";
	}

	public function structure(){
		$Locale = \App::getLocale();
		$this['title']         = isset($this['title_'.$Locale]) ? $this['title_'.$Locale] : "";
		$this['description']   = isset($this['description_'.$Locale]) ? $this['description_'.$Locale] : "";
		$this['content']       = isset($this['content_'.$Locale]) ? \base64_decode($this['content_'.$Locale]) : "";
		$this['featuredImage'] = $this->getFeaturedImage();
		$this['thumbnail']     = $this->thumbnail();
		$this['url']           = $this->url();
	}

}
