<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;

class SliderSlide extends Model{

    use Afrodien;
	protected $table = 'slider_slides';

	public function slider(){
		return $this->belongsTo("App\Slider");
    }

	public function getImage(){
		if(isset($this->image) && !empty($this->image) && \file_exists(storage_path('app/public/images/original/'.$this->image))){
			$image = $this->image('/images/original/',$this->image);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

	public function structure(){
		$Locale = \App::getLocale();
		$this['title']         = isset($this['title_'.$Locale]) ? $this['title_'.$Locale] : "";
		$this['description']   = isset($this['description_'.$Locale]) ? $this['description_'.$Locale] : "";
		$this['image']         = $this->getImage();
    }

}
