<?php

namespace App\Traits;

trait Afrodien {

	public function prepareViewer(){
		$this->data['popularPosts'] = \App\Post::with('category')->active()->whereIn('post_id',explode(',',\Config::get('app.popular.posts')))->limit(3)->get();
		$this->data['popularPosts']->each(function($post){
			$post->structure();
		});

		$Copyright = \Config::get('app.copyright');
		$Copyright[\Config::get('app.locale')] = str_replace('[year]',date('Y'),$Copyright[\Config::get('app.locale')]);
		$Copyright[\Config::get('app.locale')] = str_replace('[website_name]',\Config::get('app.name')[\Config::get('app.locale')],$Copyright[\Config::get('app.locale')]);
		\Config::set('app.copyright',$Copyright);
	}

	public function image($path,$__image){
	    if(!file_exists(\storage_path('app/public/'.trim($path,'/').'/'.trim($__image,'/')))){
    	$image['width'] = "";
		$image['height'] = "";
		$image['attributes'] = "";
		$image['type'] = "";
		$image['name'] = "";
		$image['src'] = "";
		return $image;
	    }
		$_image = getimagesize(\storage_path('app/public/'.trim($path,'/').'/'.trim($__image,'/')));
		$image['width'] = $_image[0];
		$image['height'] = $_image[1];
		$image['attributes'] = $_image[3];
		$image['type'] = $_image['mime'];
		$image['name'] = $__image;
		$image['src'] = url('storage/'.trim($path,'/').'/'.trim($__image,'/'));
		return $image;
	}

	public function video($path,$__image){
		$image['name'] = $__image;
		$image['src'] = url(trim($path,'/').'/'.trim($__image,'/'));
		return $image;
	}

	public function getMeta(){
		if(isset($this->data['meta'])){
			dd("meta already set");
		}
		$items      = ['page','post','category','tag','service','gallery'];
		$this->data['meta'] = [];
		foreach ($items as $item) {
			$this->data['meta']['title']         = $this->data[$item]['title'] ?? $this->data['meta']['title'] ?? "";
			$this->data['meta']['description']   = $this->data[$item]['description'] ?? $this->data['meta']['description'] ?? "";
			$this->data['meta']['keywords']      = $this->data[$item]['keywords'] ?? $this->data['meta']['keywords'] ?? "";
			$this->data['meta']['robots']        = $this->data[$item]['robots'] ?? $this->data['meta']['robots'] ?? "";
			$this->data['meta']['featuredImage'] = $this->data[$item]['featuredImage'] ?? $this->data['meta']['featuredImage'] ?? "";
			$this->data['meta']['canonical']     = \Config::get('app.canonical');
		}
	}

}
