<?php

namespace App\Traits;

use Illuminate\Support\Facades\Hash;

trait VirtualSystemViewer {


	function setMultimedia($multimedia,$VirtualSystem,$item){

		$primaryKey = \SystemBuilder::createKey($VirtualSystem->table);
		$systemKey = $VirtualSystem->key;

		foreach ($multimedia as $media) {
			\DB::table($media['name'].'_'.$VirtualSystem->table.'_media')->where($primaryKey, $item->$systemKey)->delete();
			if(!empty(\request($media['name']))){
				foreach (\request($media['name']) as $value){
					if(!empty($value)){
						\DB::table($media['name'].'_'.$VirtualSystem->table.'_media')->insert([
							'media_id' => $value,
							$primaryKey => $item->$systemKey
						]);
					}
				}
			}
		}
	}

	function setFields($VirtualSystem,$item,$status){
		foreach ($VirtualSystem->fields as $field){
		    if($field['type']=="password" && $status=="update"){

	        }else{
    			if($field['has_relation'] && $field['relation']['type']=="many"){
    				$this->relations[$field['name']] = $field;
    			}elseif ($field['type']=="multimedia") {
    				$this->multimedia[$field['name']] = $field;
    			}elseif ($field['multi_languages'] == "1" && $field['has_relation']!=1) {
    				foreach (\Config::get('app.languages') as $language) {
    					$this->prepareField($item,$field,$field['name'] . '_' . $language->prefix,$status,$VirtualSystem);
    				}
    			}else{
    				$this->prepareField($item,$field,$field['name'],$status,$VirtualSystem);
    			}
		    }
		}
	}

	function setRelations($relations,$VirtualSystem,$item){
		$primaryKey = \SystemBuilder::createKey($VirtualSystem->table);
		$systemKey = $VirtualSystem->key;


		foreach ($relations as $field) {

			$key2 = \SystemBuilder::createKey($field['relation']['table']);
			$table_name = $field['name'].'_'.$VirtualSystem->table.'_'.$field['relation']['table'].'_r';
			\DB::table($table_name)->where($primaryKey, $item->$systemKey)->delete();



			foreach (\request($field['name']) ?? [] as $value) {
				\DB::table($table_name)->insert([
					$primaryKey => $item->$systemKey,
					$key2 => $value
				]);
			}
		}

	}

	function prepareField($item,$field,$field_name,$status,$VirtualSystem){
		$this->validation[$field_name] = \VirtualSystem::setValidation($field,$status,$VirtualSystem,$item);
		$item->$field_name = \request($field_name);
		if($field['type']=='content'){
			$item->$field_name = \base64_encode($item->$field_name);
		}elseif($field['type']=='password'){
			$item->$field_name = Hash::make($item->$field_name);
		}
	}

}
?>
