<?php

namespace App;

use App\Traits\HasRolesAndPermissions;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable implements MustVerifyEmail {
	use Notifiable,HasRolesAndPermissions;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password','avatar','username'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

	public function avatar(){
		if(isset($this->avatar) && !empty($this->avatar)){
			return url('storage/users/'.$this->avatar);
		}else{
			return url('storage/users/user.jpg');
		}
	}

	public function services(){
		return $this->hasMany('App\UserService','user_id','id')->with('details');
	}

	public function products(){
		return $this->hasMany('App\UserProduct','user_id','id')->with('details');
	}

	public function surveys(){
        return $this->belongsToMany(Survey::class,'for_surveys_users_roles_r','user_role_id','survey_id');
    }




}
