<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisitorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('visitors', function (Blueprint $table) {
			$table->uuid('id')->primary();
			$table->bigInteger('user_id')->nullable();
			$table->string('agent');
			$table->string('country');
			$table->string('region');
			$table->string('city');
			$table->string('ip');
			$table->string('locale');
			$table->string('browser');
			$table->string('browser_version');
			$table->string('languages');
			$table->string('device');
			$table->string('platform');
			$table->string('platform_version');
			$table->string('robot');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('visitors');
    }
}
