<?php

use Illuminate\Database\Seeder;
use App\VirtualSystem;

class VirtualSystemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run(){

		$virtual = new App\Http\Controllers\VirtualSystemController();


		$System = new VirtualSystem();
		$System->slug = 'users';
		$System->title_en = 'Users';
		$System->title_ar = 'المستخدمين';
		$System->fields = '[{"label":{"en":"Full Name","ar":"\u0627\u0644\u0627\u0633\u0645 \u0628\u0627\u0644\u0643\u0627\u0645\u0644"},"name":"name","type":"text","is_required":"1","has_relation":"0","unique":"1","multi_languages":"0","display":"0","relation":{"type":"one","table":"categories","key":null,"show":null}},{"label":{"en":"Username","ar":"\u0627\u0633\u0645 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645"},"name":"username","type":"text","is_required":"1","has_relation":"0","unique":"1","multi_languages":"0","display":"1","relation":{"type":"one","table":"categories","key":null,"show":null}},{"label":{"en":"Email","ar":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a"},"name":"email","type":"email","is_required":"0","has_relation":"0","unique":"1","multi_languages":"0","display":"1","relation":{"type":"one","table":"categories","key":null,"show":null}},{"label":{"en":"Password","ar":"\u0643\u0644\u0645\u0647 \u0627\u0644\u0633\u0631"},"name":"password","type":"password","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"categories","key":null,"show":null}},{"label":{"en":"Job title","ar":"\u0627\u0644\u0645\u0633\u0645\u0649 \u0627\u0644\u0648\u0638\u064a\u0641\u064a"},"name":"job_title","type":"text","is_required":"0","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"categories","key":null,"show":null}},{"label":{"en":"About","ar":"\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0639\u0646 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645"},"name":"about","type":"long_text","is_required":"0","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"categories","key":null,"show":null}},{"label":{"en":"Location","ar":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646"},"name":"location","type":"text","is_required":"0","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"categories","key":null,"show":null}},{"label":{"en":"Banned until","ar":"\u0645\u062d\u0638\u0648\u0631 \u062d\u062a\u0649"},"name":"banned_until","type":"datetime","is_required":"0","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Profile picture","ar":"\u0627\u0644\u0635\u0648\u0631\u0647 \u0627\u0644\u0634\u062e\u0635\u064a\u0647"},"name":"avatar","type":"avatar","is_required":"0","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Email verified at","ar":"\u062a\u0645  \u062a\u0623\u0643\u064a\u062f \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0641\u064a"},"name":"email_verified_at","type":"datetime","is_required":"0","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"categories","key":null,"show":null}},{"label":{"en":"Roles","ar":"\u0627\u0644\u0623\u062f\u0648\u0627\u0631"},"name":"roles","type":"number","is_required":"0","has_relation":"1","unique":"0","multi_languages":"1","display":"0","relation":{"type":"many","table":"roles","key":"id","show":"name_en"}},{"label":{"en":"Permissions","ar":"\u0627\u0644\u0635\u0644\u0627\u062d\u064a\u0627\u062a"},"name":"permissions","type":"checkboxlist","is_required":"0","has_relation":"1","unique":"0","multi_languages":"1","display":"0","relation":{"type":"many","table":"permissions","key":"id","show":"name_en"}}]';
		$System->table = 'users';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'users';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
		$System->slug = 'roles';
		$System->title_en = 'User Roles';
		$System->title_ar = 'أدوار المستخدمين';
		$System->fields = '[{"label":{"en":"Name","ar":"\u0627\u0644\u0623\u0633\u0645"},"name":"name","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Slug","ar":"\u0627\u0644\u0645\u0639\u0631\u0641"},"name":"slug","type":"text","is_required":"0","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Permissions","ar":"\u0627\u0644\u0635\u0644\u0627\u062d\u064a\u0627\u062a"},"name":"permissions","type":"checkboxlist","is_required":"0","has_relation":"1","unique":"0","multi_languages":"1","display":"0","relation":{"type":"many","table":"permissions","key":"id","show":"name_en"}}]';
		$System->table = 'roles';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'User Roles';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'permissions';
		$System->title_en = 'Permissions';
		$System->title_ar = 'الصلاحيات';
		$System->fields = '[{"label":{"en":"Name","ar":"\u0627\u0644\u0623\u0633\u0645"},"name":"name","type":"text","is_required":"1","has_relation":"0","unique":"0","source":"user","multi_languages":"1","display":"1","relation":{"key":null,"show":null}},{"label":{"en":"Slug","ar":"\u0627\u0644\u0645\u0639\u0631\u0641"},"name":"slug","type":"text","is_required":"0","has_relation":"0","unique":"0","source":"user","multi_languages":"0","display":"0","relation":{"key":null,"show":null}}]';
		$System->table = 'permissions';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Permissions';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'users-activities';
		$System->title_en = 'Users activities';
		$System->title_ar = 'أنشطة المستخدمين';
		$System->fields = '[{"label":{"en":"Activity","ar":"\u0627\u0644\u0646\u0634\u0627\u0637"},"name":"body","type":"text","is_required":"1","has_relation":"0","unique":"0","source":"user","multi_languages":"0","display":"1","relation":{"key":null,"show":null}},{"label":{"en":"URL","ar":"\u0639\u0646\u0648\u0627\u0646 \u0635\u0641\u062d\u0629 \u0627\u0644\u0648\u064a\u0628"},"name":"url","type":"text","is_required":"0","has_relation":"0","unique":"0","source":"user","multi_languages":"0","display":"0","relation":{"key":null,"show":null}},{"label":{"en":"Method","ar":"\u0627\u0644\u0648\u0633\u064a\u0644\u0629"},"name":"method","type":"text","is_required":"0","has_relation":"0","unique":"0","source":"user","multi_languages":"0","display":"0","relation":{"key":null,"show":null}},{"label":{"en":"IP","ar":"\u0627\u064a \u0628\u064a"},"name":"ip","type":"text","is_required":"0","has_relation":"0","unique":"0","source":"user","multi_languages":"0","display":"0","relation":{"key":null,"show":null}},{"label":{"en":"User Agent","ar":"\u0645\u0639\u0631\u0641 \u0627\u0644\u0645\u062a\u0635\u0641\u062d"},"name":"agent","type":"text","is_required":"0","has_relation":"0","unique":"0","source":"user","multi_languages":"0","display":"0","relation":{"key":null,"show":null}},{"label":{"en":"Username","ar":"\u0627\u0633\u0645 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645"},"name":"user_id","type":"number","is_required":"1","has_relation":"1","unique":"0","source":"user","multi_languages":"0","display":"1","relation":{"type":"one","table":"users","key":"id","show":"username"}}]';
		$System->table = 'users_activities';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Users Activities';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'pages';
		$System->title_en = 'Pages';
		$System->title_ar = 'Pages';
		$System->fields = '[{"label":{"en":"Slug","ar":"\u0627\u0644\u0645\u0639\u0631\u0641"},"name":"slug","type":"text","is_required":"1","has_relation":"0","unique":"1","multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Title","ar":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646"},"name":"title","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Description","ar":"\u0627\u0644\u0648\u0635\u0641"},"name":"description","type":"long_text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Content","ar":"\u0627\u0644\u0645\u062d\u062a\u0648\u064a"},"name":"content","type":"content","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Status","ar":"\u0627\u0644\u062d\u0627\u0644\u0629"},"name":"status","type":"options","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"1","values":[{"name":"published","label":{"en":"Published","ar":"undefined"}},{"name":"draft","label":{"en":"Draft","ar":"undefined"}}],"relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Slider","ar":"\u0633\u0644\u0627\u064a\u062f\u0631"},"name":"slider_id","type":"number","is_required":"0","has_relation":"1","unique":"0","multi_languages":"1","display":"0","relation":{"type":"one","table":"slider","key":"id","show":"name_en"}},{"label":{"en":"Featured image","ar":"\u0635\u0648\u0631\u0629 \u0627\u0644\u0645\u0645\u064a\u0632\u0629"},"name":"featured_image","type":"image","is_required":"0","has_relation":"1","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"media","key":"name","show":"name"}}]';
		$System->table = 'pages';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Pages';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
		$System->slug = 'posts';
		$System->title_en = 'Posts';
		$System->title_ar = 'المنشورات';
		$System->fields = '[{"label":{"en":"Slug","ar":"\u0627\u0644\u0645\u0639\u0631\u0641"},"name":"post_slug","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Title","ar":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646"},"name":"post_title","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Description","ar":"\u0627\u0644\u0648\u0635\u0641"},"name":"post_description","type":"long_text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Content","ar":"\u0627\u0644\u0645\u062d\u062a\u0648\u064a"},"name":"post_content","type":"content","is_required":"0","has_relation":"0","unique":"0","multi_languages":"1","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Status","ar":"\u0627\u0644\u062d\u0627\u0644\u0629"},"name":"post_status","type":"options","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"1","values":[{"name":"published","label":{"en":"Published","ar":"undefined"}},{"name":"draft","label":{"en":"Draft","ar":"undefined"}}],"relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Comment Status","ar":"\u062d\u0627\u0644\u0647 \u0627\u0644\u062a\u0639\u0644\u064a\u0642\u0627\u062a"},"name":"post_comment_status","type":"options","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"0","values":[{"name":"closed","label":{"en":"closed","ar":"undefined"}},{"name":"open","label":{"en":"open","ar":"undefined"}}],"relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Category","ar":"\u0627\u0644\u062a\u0635\u0646\u064a\u0641"},"name":"post_category_id","type":"number","is_required":"1","has_relation":"1","unique":"0","multi_languages":"1","display":"1","relation":{"type":"one","table":"categories","key":"id","show":"title_en"}},{"label":{"en":"Tags","ar":"\u0627\u0644\u0648\u0633\u0648\u0645"},"name":"post_tags","type":"number","is_required":"0","has_relation":"1","unique":"0","multi_languages":"1","display":"0","relation":{"type":"many","table":"tags","key":"id","show":"title_en"}},{"label":{"en":"Featured image","ar":"\u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0645\u0645\u064a\u0632\u0629"},"name":"post_featured_image","type":"image","is_required":"0","has_relation":"1","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"media","key":"name","show":"name"}}]';
		$System->table = 'posts';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Posts System | plz, be careful while modifying this system';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
		$System->slug = 'categories';
		$System->title_en = 'Post Categories';
		$System->title_ar = 'Post Categories';
		$System->fields = '[{"label":{"en":"Slug","ar":"\u0627\u0644\u0645\u0639\u0631\u0641"},"name":"category_slug","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Title","ar":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646"},"name":"category_title","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Description","ar":"\u0627\u0644\u0648\u0635\u0641"},"name":"category_description","type":"long_text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Status","ar":"\u0627\u0644\u062d\u0627\u0644\u0629"},"name":"category_status","type":"options","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"1","values":[{"name":"published","label":{"en":"Published","ar":"undefined"}},{"name":"draft","label":{"en":"Draft","ar":"undefined"}}],"relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Featured image","ar":"\u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0645\u0645\u064a\u0632\u0629"},"name":"category_featured_image","type":"image","is_required":"0","has_relation":"1","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"media","key":"name","show":"name"}}]';
		$System->table = 'categories';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'categories';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'tags';
		$System->title_en = 'Tags';
		$System->title_ar = 'Tags';
		$System->fields = '[{"label":{"en":"Slug","ar":"\u0627\u0644\u0645\u0639\u0631\u0641"},"name":"tag_slug","type":"text","is_required":"1","has_relation":"0","unique":"1","multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Title","ar":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646"},"name":"tag_title","type":"text","is_required":"1","has_relation":"0","unique":"1","multi_languages":"1","display":"1","relation":{"key":null,"show":null}},{"label":{"en":"Description","ar":"\u0627\u0644\u0648\u0635\u0641"},"name":"tag_description","type":"long_text","is_required":"1","has_relation":"0","unique":"1","multi_languages":"1","display":"0","relation":{"key":null,"show":null}},{"label":{"en":"Featured image","ar":"\u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0645\u0645\u064a\u0632\u0629"},"name":"tag_featured_image","type":"image","is_required":"0","has_relation":"1","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"media","key":"name","show":"name"}}]';
		$System->table = 'tags';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Tags';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
		$System->slug = 'comments';
		$System->title_en = 'Comments';
		$System->title_ar = 'Comments';
		$System->fields = '[{"label":{"en":"User ID","ar":"\u0645\u0639\u0631\u0641 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645"},"name":"user_id","type":"number","is_required":"0","has_relation":"1","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"users","key":"id","show":"username"}},{"label":{"en":"Post title","ar":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0645\u0646\u0634\u0648\u0631"},"name":"post_id","type":"number","is_required":"1","has_relation":"1","unique":"0","multi_languages":"1","display":"1","relation":{"type":"one","table":"posts","key":"id","show":"title_en"}},{"label":{"en":"Reply to","ar":"\u0631\u062f \u0639\u0644\u064a"},"name":"parent_id","type":"number","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"1","relation":{"type":"one","table":"comments","key":"id","show":"body"}},{"label":{"en":"Name","ar":"\u0627\u0644\u0623\u0633\u0645"},"name":"name","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Email","ar":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a"},"name":"email","type":"email","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Status","ar":"\u0627\u0644\u062d\u0627\u0644\u0629"},"name":"status","type":"options","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"1","values":[{"name":"published","label":{"en":"Published","ar":"published"}},{"name":"in_review","label":{"en":"in review","ar":"in review"}}],"relation":{"type":null,"table":null,"key":"post_id","show":"post_title_en"}},{"label":{"en":"Comment","ar":"\u0627\u0644\u062a\u0639\u0644\u064a\u0642"},"name":"body","type":"long_text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Picture","ar":"\u0627\u0644\u0635\u0648\u0631\u0629"},"name":"avatar","type":"avatar","is_required":"0","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"key":null,"show":null}}]';
		$System->table = 'comments';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Comments';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'slides';
		$System->title_en = 'Slides';
		$System->title_ar = 'Slides';
		$System->fields = '[{"label":{"en":"Title","ar":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646"},"name":"title","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"1","relation":{"key":null,"show":null}},{"label":{"en":"Description","ar":"\u0627\u0644\u0648\u0635\u0641"},"name":"description","type":"long_text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"0","relation":{"key":null,"show":null}},{"label":{"en":"URL","ar":"\u0627\u0644\u0631\u0627\u0628\u0637"},"name":"url","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"key":null,"show":null}},{"label":{"en":"Order","ar":"\u0627\u0644\u062a\u0631\u062a\u064a\u0628"},"name":"order","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"key":null,"show":null}},{"label":{"en":"image","ar":"\u0627\u0644\u0635\u0648\u0631\u0629"},"name":"image","type":"image","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"key":null,"show":null}},{"label":{"en":"slider Name","ar":"\u0623\u0633\u0645 \u0627\u0644\u0633\u0644\u0627\u064a\u062f\u0631"},"name":"slider_id","type":"number","is_required":"1","has_relation":"1","unique":"0","multi_languages":"1","display":"1","relation":{"type":"one","table":"slider","key":"id","show":"name_en"}}]';
		$System->table = 'slides';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Slides';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'slider';
		$System->title_en = 'Slider';
		$System->title_ar = 'السلايدر';
		$System->fields = '[{"label":{"en":"Name","ar":"\u0627\u0644\u0623\u0633\u0645"},"name":"name","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Template","ar":"\u0627\u0644\u0642\u0627\u0644\u0628"},"name":"template","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Type","ar":"\u0627\u0644\u0646\u0648\u0639"},"name":"type","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Max Slides","ar":"\u0639\u062f\u062f \u0627\u0644\u0634\u0631\u0627\u0626\u062d"},"name":"max_slides","type":"number","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"key":null,"show":null}},{"label":{"en":"Category","ar":"\u0627\u0644\u062a\u0635\u0646\u064a\u0641"},"name":"category_id","type":"number","is_required":"0","has_relation":"1","unique":"0","multi_languages":"1","display":"0","relation":{"type":"one","table":"categories","key":"id","show":"title_en"}}]';
		$System->table = 'slider';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Slider';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'newsletter-subscribers';
		$System->title_en = 'Newsletter Subscribers';
		$System->title_ar = 'Newsletter Subscribers';
		$System->fields = '[{"label":{"en":"Name","ar":null},"name":"name","type":"text","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Email","ar":null},"name":"email","type":"email","is_required":"1","has_relation":"0","unique":"1","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Status","ar":null},"name":"status","type":"options","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","values":[{"name":"activated","label":{"en":"activated","ar":"activated"}},{"name":"inactive","label":{"en":"inactive","ar":"inactive"}},{"name":"blocked","label":{"en":"blocked","ar":"blocked"}}],"relation":{"type":null,"table":null,"key":null,"show":null}}]';
		$System->table = 'newsletter_subscribers';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Newsletter Subscribers';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'sent-notifications';
		$System->title_en = 'Sent Notifications';
		$System->title_ar = 'Sent Notifications';
		$System->fields = '[{"label":{"en":"Body","ar":null},"name":"body","type":"long_text","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Sent to","ar":null},"name":"to","type":"options","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","values":[{"name":"user","label":{"en":"User","ar":"User"}},{"name":"all_users","label":{"en":"All Users","ar":"All Users"}},{"name":"all_subscribers","label":{"en":"All Subscribers","ar":"All Subscribers"}}],"relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Total","ar":null},"name":"total_recipients","type":"number","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Success","ar":null},"name":"success_recipients","type":"number","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Failure","ar":null},"name":"failure_recipients","type":"number","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Opened","ar":null},"name":"opened","type":"number","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"status","ar":null},"name":"status","type":"options","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","values":[{"name":"success","label":{"en":"success","ar":"success"}},{"name":"failed","label":{"en":"Failed","ar":"Failed"}},{"name":"scheduled","label":{"en":"Scheduled","ar":"Scheduled"}}],"relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"result","ar":null},"name":"result","type":"long_text","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"click action","ar":null},"name":"click_action","type":"text","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Icon","ar":null},"name":"icon","type":"text","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Image","ar":null},"name":"image","type":"text","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Title","ar":null},"name":"title","type":"text","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}}]';
		$System->table = 'notifications_sent';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Sent Notifications';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'notifications-subscribers';
		$System->title_en = 'Notifications Subscribers';
		$System->title_ar = 'Notifications Subscribers';
		$System->fields = '[{"label":{"en":"Token","ar":null},"name":"token","type":"text","is_required":"1","has_relation":"0","unique":"1","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"User ID","ar":null},"name":"user_id","type":"number","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Visitor ID","ar":null},"name":"visitor_id","type":"long_text","is_required":"1","has_relation":"0","unique":"1","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Last Seen","ar":null},"name":"last_seen","type":"datetime","is_required":"1","has_relation":"0","unique":"0","source":"user","multi_languages":"0","display":"1","relation":{"type":"one","key":"visitor_id","show":"last_seen"}}]';
		$System->table = 'notifications_subscribers';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Notifications Subscribers';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'search-report';
		$System->title_en = 'Search report';
		$System->title_ar = 'Search report';
		$System->fields = '[{"label":{"en":"Search term","ar":null},"name":"term","type":"text","is_required":"1","has_relation":"0","unique":"1","source":null,"data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Total Searchs","ar":null},"name":"counter","type":"number","is_required":"1","has_relation":"0","unique":"0","source":null,"data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}}]';
		$System->table = 'reports_search';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'For search report system. Plz, do not modify anything here.';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'error-pages';
		$System->title_en = 'Error 404 Report';
		$System->title_ar = 'Error 404 Report';
		$System->fields = '[{"label":{"en":"URL","ar":null},"name":"url","type":"text","is_required":"1","has_relation":"0","unique":"1","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Counter","ar":null},"name":"counter","type":"number","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}}]';
		$System->table = 'reports_error_pages';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Error 404 Report';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'redirections';
		$System->title_en = 'Redirections';
		$System->title_ar = 'Redirections';
		$System->fields = '[{"label":{"en":"URL","ar":null},"name":"url","type":"text","is_required":"1","has_relation":"0","unique":"1","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Redirect to","ar":null},"name":"redirect_to","type":"text","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}}]';
		$System->table = 'redirections';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Redirections';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'banned-ip';
		$System->title_en = 'Banned IP';
		$System->title_ar = 'Banned IP';
		$System->fields = '[{"label":{"en":"IP","ar":null},"name":"ip","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Reason","ar":null},"name":"reason","type":"long_text","is_required":"1","has_relation":"0","unique":"1","multi_languages":"0","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"agent","ar":null},"name":"agent","type":"long_text","is_required":"0","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}}]';
		$System->table = 'banned_ip';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'For Banned IP System. plz, do not change any thing here.';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'documentation';
		$System->title_en = 'Documentation';
		$System->title_ar = 'Documentation';
		$System->fields = '[{"label":{"en":"slug","ar":"slug"},"name":"slug","type":"text","is_required":"1","has_relation":"0","unique":"1","source":"user","data_type":null,"multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Title","ar":null},"name":"title","type":"text","is_required":"1","has_relation":"0","unique":"1","source":"user","data_type":null,"multi_languages":"1","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Description","ar":null},"name":"description","type":"long_text","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"1","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Content","ar":null},"name":"content","type":"content","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"1","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"category","ar":null},"name":"category_id","type":"number","is_required":"1","has_relation":"1","unique":"1","source":"user","multi_languages":"1","display":"1","relation":{"type":"one","table":"documentation_categories","key":"id","show":"title_en"}}]';
		$System->table = 'documentation';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Documentation';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'documentation-categories';
		$System->title_en = 'Documentation Category';
		$System->title_ar = 'Documentation Category';
		$System->fields = '[{"label":{"en":"Prefix","ar":null},"name":"prefix","type":"text","is_required":"1","has_relation":"0","unique":"0","source":null,"data_type":null,"multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Title","ar":null},"name":"title","type":"text","is_required":"1","has_relation":"0","unique":"1","source":null,"data_type":null,"multi_languages":"1","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Description","ar":null},"name":"description","type":"long_text","is_required":"1","has_relation":"0","unique":"0","source":null,"data_type":null,"multi_languages":"1","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}}]';
		$System->table = 'documentation_categories';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Documentation Category';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'help';
		$System->title_en = 'Help';
		$System->title_ar = 'Help';
		$System->fields = '[{"label":{"en":"slug","ar":null},"name":"slug","type":"text","is_required":"0","has_relation":"1","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"0","relation":{"type":"one","table":"virtual_systems","key":"slug","show":"title_en"}},{"label":{"en":"Action","ar":null},"name":"action","type":"options","is_required":"1","has_relation":"0","unique":"0","source":"user","data_type":null,"multi_languages":"0","display":"0","values":[{"name":"view_all","label":{"en":"View All","ar":"\u0639\u0631\u0636 \u0627\u0644\u0643\u0644"}},{"name":"new","label":{"en":"New","ar":"\u0627\u0636\u0627\u0641\u0647"}},{"name":"edit","label":{"en":"Edit","ar":"\u062a\u0639\u062f\u064a\u0644"}},{"name":"view_one","label":{"en":"View One","ar":"\u0639\u0631\u0636 \u0639\u0646\u0635\u0631 \u0648\u0627\u062d\u062f"}},{"name":"delete","label":{"en":"Delete","ar":"\u062d\u0630\u0641"}}],"relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Title","ar":null},"name":"title","type":"text","is_required":"1","has_relation":"0","unique":"1","source":"user","data_type":null,"multi_languages":"1","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"Content","ar":null},"name":"content","type":"content","is_required":"1","has_relation":"0","unique":"1","source":"user","data_type":null,"multi_languages":"1","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}}]';
		$System->table = 'help';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Help';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'faqs';
		$System->title_en = 'FAQs';
		$System->title_ar = 'FAQs';
		$System->fields = '[{"label":{"en":"Question","ar":null},"name":"question","type":"text","is_required":"1","has_relation":"0","unique":"1","multi_languages":"1","display":"1","relation":{"key":null,"show":null}},{"label":{"en":"Answer","ar":null},"name":"answer","type":"long_text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"0","relation":{"key":null,"show":null}}]';
		$System->table = 'faqs';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'FAQs';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'testimonials';
		$System->title_en = 'Testimonials';
		$System->title_ar = 'Testimonials';
		$System->fields = '[{"label":{"en":"Name","ar":"\u0627\u0644\u0623\u0633\u0645"},"name":"name","type":"text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"1","relation":{"key":null,"show":null}},{"label":{"en":"Testimonial","ar":null},"name":"testimonial","type":"long_text","is_required":"1","has_relation":"0","unique":"0","multi_languages":"1","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}}]';
		$System->table = 'testimonials';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'Testimonials';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'to-do-list';
		$System->title_en = 'To Do List';
		$System->title_ar = 'To Do List';
		$System->fields = '[{"label":{"en":"task","ar":null},"name":"body","type":"text","is_required":"0","has_relation":"0","unique":"0","multi_languages":"0","display":"0","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"status","ar":null},"name":"status","type":"options","is_required":"0","has_relation":"0","unique":"0","multi_languages":"0","display":"0","values":[{"name":"completed","label":{"en":"completed","ar":"completed"}},{"name":"inProgress","label":{"en":"in progress","ar":"in progress"}}],"relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"user_id","ar":null},"name":"user_id","type":"number","is_required":"0","has_relation":"1","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"users","key":"id","show":"username"}}]';
		$System->table = 'to_do_list';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'To Do List';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

		$System = new VirtualSystem();
$System->slug = 'logos';
		$System->title_en = 'logos';
		$System->title_ar = 'logos';
		$System->fields = '[{"label":{"en":"name","ar":"name"},"name":"name","type":"text","is_required":"1","has_relation":"0","unique":"1","multi_languages":"1","display":"1","relation":{"type":null,"table":null,"key":null,"show":null}},{"label":{"en":"logo","ar":"logo"},"name":"logo","type":"image","is_required":"1","has_relation":"1","unique":"0","multi_languages":"0","display":"0","relation":{"type":"one","table":"media","key":"id","show":"name"}}]';
		$System->table = 'logos';
		$System->operations = 'view_all,new,edit,view_one,delete';
		$System->display = '1';
		$System->notes = 'logos';
		$System->save();
		$virtual->createPermission($System->table);
		if(!\Schema::hasTable($System->table)){
			$virtual->createTable($System->table,json_decode($System->fields,true));
		}else{
			$virtual->updateTable($System->table,json_decode($System->fields,true));
		}

    }
}
