@extends('customer.layout')
@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body col-12">
                    <div class="row">
                        <h4 class="card-title col-8 m-b-0">{{__('Invoices')}}</h4>
                    </div>

                </div>

                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-light">
                        <tr>
                            <th scope="col">{{__('Invoice ID')}}</th>
                            <th scope="col">{{__('Status')}}</th>
                            <th scope="col">{{__('View')}}</th>
                        </tr>
                        </thead>
                        <tbody class="customtable">
	                        @forelse ($invoices as $invoice)
	                            <tr>
	                                <td>{{$invoice->invoice_id}}</td>
	                                <td>{{$invoice->status}}</td>
	                                <td><a class="btn btn-dark" href="{{route('customer.invoices.view',['uuid'=>$invoice->invoice_id])}}">View</a></td>
	                            </tr>
							@empty
								<tr>
									<td colspan="3">{{__('You dont have any invoices yet.')}}</td>
								</tr>
	                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
