@extends('customer.layout')
@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body bg-secondary text-white col-12">
                    <div class="row">
                        <h4 class="card-title col-8 m-b-0">{{__('Products')}}</h4>
                    </div>

                </div>

                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">{{__('Product')}}</th>
                            <th scope="col">{{__('Domain')}}</th>
                            <th scope="col">{{__('View')}}</th>
                        </tr>
                        </thead>
                        <tbody class="customtable">
                        @forelse($products ?? [] as $product)
                            <tr>
                                <td>{{$product->id}}</td>
								<td>{{$product->details['title_'.\Config::get('app.locale')]}}</td>
                                <td>{{$product->domain}}</td>
                                <td><a class="btn btn-dark" href="{{route('customer.products.view',$product->id)}}">View</a></td>
                            </tr>
						@empty
							<tr>
								<td colspan="3">{{__('You dont have any products yet.')}}</td>
							</tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
