@extends('customer.layout')

@section('content')
  <div class="row">
      <div class="col-md-12">
          <div class="card">
              <form class="form-horizontal" id="updateProfile-form" action="{{ route('customer.profile.update') }}" method="post">
                @csrf
                  <div class="card-header bg-secondary text-white">
					  <h4 class="card-title">{{__('Personal Info')}}</h4>
				  </div>

                  <div class="card-body">
                      <div class="form-group row">
                          <label for="username" class="col-sm-3 text-right control-label col-form-label">{{__('Username')}}</label>
                          <div class="col-sm-9">
                              <input type="text" disabled class="form-control" name="username" id="username" placeholder="{{__('Username')}}" value="{{ $user->username }}">
                          </div>
                      </div>

                      <div class="form-group row">
                          <label for="email" class="col-sm-3 text-right control-label col-form-label">{{__('Email and Phone')}}</label>
                          <div class="col-sm-9 input-group">
                              <input type="email" class="form-control col-6" name="email" id="email" disabled placeholder="{{__('Email')}}" value="{{ $user->email }}">
                              <input type="text" class="form-control col-6" name="phone" id="phone" placeholder="{{__('Phone')}}" value="{{ $user->phone }}">
                          </div>
                      </div>
					  <div class="form-group row">
					  	<label class="col-sm-3 text-right control-label col-form-label">{{__('Prefix')}}</label>
					  	<div class="col-md-9">
					  		<select class="select2 form-control custom-select" name="prefix" id="prefix" style="width: 100%; height:36px;">
					  				<option value="">{{__('Non Mentioned')}}</option>
					  				<option @if($user->prefix == "Dr") selected @endif value="Dr">{{__('Dr.')}}</option>
					  				<option @if($user->prefix == "Eng") selected @endif value="Eng">{{__('Eng.')}}</option>
					  		</select>
					  	</div>
					  </div>
                      <div class="form-group row">
                          <label for="lname" class="col-sm-3 text-right control-label col-form-label">{{__('Full Name')}}</label>
                          <div class="col-sm-9">
                              <input type="text" class="form-control" name="name" id="name" placeholder="{{__('Full Name')}}" value="{{ $user->name }}">
                          </div>
                      </div>
                      <div class="form-group row">
                          <label class="col-sm-3 text-right control-label col-form-label">{{__('Gender')}}</label>
                          <div class="col-md-9">
                              <select class="select2 form-control custom-select" name="gender" id="gender" style="width: 100%; height:36px;">
                                      <option value="">{{__('Non Mentioned')}}</option>
                                      <option @if($user->gender == "male") selected @endif value="male">{{__('Male')}}</option>
                                      <option @if($user->gender == "female") selected @endif value="female">{{__('Female')}}</option>
                              </select>
                          </div>
                      </div>
                      <div class="form-group row">
                          <label for="cono1" class="col-sm-3 text-right control-label col-form-label">{{__('Job Title')}}</label>
                          <div class="col-sm-9">
                              <input type="text" class="form-control" name="job_title" id="job_title" placeholder="{{__('Job Title')}}" value="{{ $user->job_title }}">
                          </div>
                      </div>
                      <div class="form-group row">
                          <label for="cono1" class="col-sm-3 text-right control-label col-form-label">{{__('About')}}</label>
                          <div class="col-sm-9">
                              <textarea name="about" id="about" class="form-control">{{ $user->about }}</textarea>
                          </div>
                      </div>
					  <hr />
					  <div class="form-group row">
                          <label for="cono1" class="col-sm-3 text-right control-label col-form-label">{{__('Your Password')}}</label>
                          <div class="col-sm-9">
                              <input type="password" class="form-control" name="password" id="password" placeholder="{{__('Password')}}" />
                          </div>
                      </div>
                  </div>
                  <div class="border-top">
                      <div class="card-body text-not-as-lang">
                          <button type="submit" id="updateProfile" class="btn btn-primary">{{__('Submit')}}</button>
                      </div>
                  </div>
              </form>
          </div>

      </div>
  </div>
@endsection

@section('script')
	<script type="text/javascript">
		$(document).ready(function() {

			$("#updateProfile").on('click', function(e) {

				toastr.clear();
				$('.error.invalid-feedback').remove();

				var _this = $(this);
				_this.children('i').addClass('fa-spin');
				_this.children('i').addClass('fa-circle-notch');
				_this.children('i').addClass('fas');
				_this.children('i').removeClass('fa-paper-plane');
				_this.prop('disabled', true);

				var dataString = {
					email  : $('#email').val(),
					phone  : $('#phone').val(),
					prefix  : $('#prefix').val(),
					name  : $('#name').val(),
					gender  : $('#gender').val(),
					job_title  : $('#job_title').val(),
					about  : $('#about').val(),
					password  : $('#password').val()
				};

				$.ajax({
					type: "POST",
					url: $('#updateProfile-form').attr('action'),
					data: dataString,
					dataType    : 'json',
					encode      : true,
					success:function(data) {
						if(data.success){
							toastr.success(data.message);
						}else{
							if(data.message){
								toastr.error(data.message);
							}
							$.each(data.errors, function( index, value ) {
								toastr.error(value);
							});
						}
					},
					error:function(data){
						if(data.responseJSON.message){
							toastr.error(data.responseJSON.message);
						}
						$.each(data.responseJSON.errors, function( index, value ) {
							toastr.error(value);
							$('.form-control[name='+index+']').addClass('is-invalid');
							$('.form-control[name='+index+']').parent().append('<span id="password-error" class="error invalid-feedback">'+value+'</span>');
						});
					},
					complete: function (data) {
						_this.children('i').removeClass('fa-spin');
						_this.children('i').removeClass('fa-circle-notch');
						_this.children('i').removeClass('fas');
						_this.children('i').addClass('fa-paper-plane');
						_this.prop('disabled', false);
					}
				});
				e.preventDefault();
			});

			$('.select2').select2();
		})
	</script>
@endsection
