@extends('customer.layout')
@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body bg-secondary text-white col-12">
                    <div class="row">
                        <h4 class="card-title col-8 m-b-0">{{__('Surveys')}}</h4>
                    </div>

                </div>

                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-light">
                        <tr>
                            <th scope="col">{{__('Survey ID')}}</th>
							<th scope="col">{{__('Survey Name')}}</th>
                        </tr>
                        </thead>
                        <tbody class="customtable">
	                        @forelse ($surveys as $survey)
	                            <tr>
	                                <td>{{$survey->id}}</td>
	                                <td><a href="{{route('customer.surveys.view',['id'=>$survey->id])}}">{{$survey->title}}</a></td>
	                            </tr>
							@empty
								<tr>
									<td colspan="3">{{__('No Surveys.')}}</td>
								</tr>
	                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
