@extends('customer.layout')
@section('content')

<div class="row">
    <div class="col-md-12">

		<div class="card card-body">
		    <h3>
				{{$survey->title}}
			</h3>
		    <hr />

			{!!base64_decode($survey->header)!!}
		    <hr />

		    <div class="row">

				@if(count($survey->domains)>1)
				<div id="surveyFormSteps">
					@foreach ($survey->domains as $domain)
						<span class="step"></span>
					@endforeach
				</div>
				@endif

				<form id="surveyForm" action="{{route('customer.surveys.submit',['id' => $survey->id])}}">
					@foreach ($survey->domains as $domain)
						<div class="tab">

							@if($domain->show==1)
							<h1>{{$domain->code}} - {{$domain->title}}</h1>
							@endif

							<table>
								<tr>
									<th> @if($survey->type=='evaluation') {{__('Staff')}} @else {{__('elements')}} @endif </th>
									@foreach ($domain->rating as $rate)
										<th>{{$rate->name}}</th>
									@endforeach
								</tr>
								@if ($survey->type=='evaluation')
									@php
										$Users = [];
										$result = \DB::table('under_evaluation_surveys_domains_users_roles_r')->where('survey_domain_id',$domain->id)->get();
										foreach ($result as $li) {
											$role = \App\UserRole::where('id',$li->user_role_id)->with('users')->first();
											foreach ($role->users as $user) {
												$Users[$user['id']] = $user;
											}
										}
									@endphp
									@foreach ($Users as $user)
										<tr>
											<td> {{$user->name}}</td>
											@foreach ($domain->rating as $rate)
												<td>
													@if($rate->type=='1-5')
														<select class="form-control" name="rate-{{$user->id}}-{{$rate->id}}">
															<option value="" disabled selected>{{__('select value')}}</option>
															<option value="1" @if(isset($submission->submission['rate-'.$user->id.'-'.$rate->id]) && $submission->submission['rate-'.$user->id.'-'.$rate->id] == '1') selected @endif >1</option>
															<option value="2" @if(isset($submission->submission['rate-'.$user->id.'-'.$rate->id]) && $submission->submission['rate-'.$user->id.'-'.$rate->id] == '2') selected @endif >2</option>
															<option value="3" @if(isset($submission->submission['rate-'.$user->id.'-'.$rate->id]) && $submission->submission['rate-'.$user->id.'-'.$rate->id] == '3') selected @endif >3</option>
															<option value="4" @if(isset($submission->submission['rate-'.$user->id.'-'.$rate->id]) && $submission->submission['rate-'.$user->id.'-'.$rate->id] == '4') selected @endif >4</option>
															<option value="5" @if(isset($submission->submission['rate-'.$user->id.'-'.$rate->id]) && $submission->submission['rate-'.$user->id.'-'.$rate->id] == '5') selected @endif >5</option>
														</select>
													@endif
												</td>
											@endforeach
										</tr>
									@endforeach
								@else
									@foreach ($domain->elements as $element)
										<tr>
											<td> {{$domain->code}}/{{$element->code}} - {{$element->text}}</td>
											@foreach ($domain->rating as $rate)
												<td>
													@if($rate->type=='1-5')
														<select class="form-control" name="rate-{{$element->id}}-{{$rate->id}}">
															<option value="" disabled selected>{{__('select value')}}</option>
															<option value="1" @if(isset($submission->submission['rate-'.$element->id.'-'.$rate->id]) && $submission->submission['rate-'.$element->id.'-'.$rate->id] == '1') selected @endif >1</option>
															<option value="2" @if(isset($submission->submission['rate-'.$element->id.'-'.$rate->id]) && $submission->submission['rate-'.$element->id.'-'.$rate->id] == '2') selected @endif >2</option>
															<option value="3" @if(isset($submission->submission['rate-'.$element->id.'-'.$rate->id]) && $submission->submission['rate-'.$element->id.'-'.$rate->id] == '3') selected @endif >3</option>
															<option value="4" @if(isset($submission->submission['rate-'.$element->id.'-'.$rate->id]) && $submission->submission['rate-'.$element->id.'-'.$rate->id] == '4') selected @endif >4</option>
															<option value="5" @if(isset($submission->submission['rate-'.$element->id.'-'.$rate->id]) && $submission->submission['rate-'.$element->id.'-'.$rate->id] == '5') selected @endif >5</option>
														</select>
													@endif
												</td>
											@endforeach
										</tr>
									@endforeach
								@endif
							</table>
						</div>
					@endforeach

					<br>
					<br>

					<div class="text-center">
						@if($submission && $submission->completed==1)
							<button type="button" class="btn btn-success" id="prevBtn" onclick="nextPrev(-1)">{{__('Prev')}}</button>
							<button type="button" class="btn btn-success" id="nextBtn" onclick="nextPrev(1)">{{__('Next')}}</button>
							<br>
							<br>
							<p>{{__('You have submitted this survey.')}}</p>
						@else
							<button type="button" class="btn btn-success" id="prevBtn" onclick="nextPrev(-1)">{{__('Prev')}}</button>
							<button type="button" class="btn btn-success" id="nextBtn" onclick="nextPrev(1)">{{__('Next')}}</button>
							<button type="submit" class="btn btn-success" id="submitBtn">{{__('Submit')}}</button>
						@endif
					</div>

				</form>

			</div>
		</div>


    </div>
</div>
@endsection

@section('script')
	<script type="text/javascript">

		$("#submitBtn").on('click', function(e) {

			var vaild = true;
			toastr.clear();
			$('.error.invalid-feedback').remove();

			var _this = $(this);
			_this.children('i').addClass('fa-spin');
			_this.children('i').addClass('fa-circle-notch');
			_this.children('i').addClass('fas');
			_this.children('i').removeClass('fa-paper-plane');
			_this.prop('disabled', true);

			var dataString = {};
			dataString['submission'] = {};

			$('#surveyForm .form-control').each(function(){
				if($(this).val()=="" || $(this).val()=="0" || $(this).val()==null){
					toastr.error('plz, fill all fields.');
					$(this).addClass('is-invalid');
					vaild = false;
				}else{
					dataString['submission'][$(this).attr('name')] = $(this).val();
				}
			});

			if(vaild){
				$.ajax({
					type: "POST",
					url: $('#surveyForm').attr('action'),
					data: dataString,
					dataType    : 'json',
					encode      : true,
					success:function(data) {
						if(data.success){
							toastr.success(data.message);
							$('#submitBtn').remove();
						}else{
							if(data.message){
								toastr.error(data.message);
							}
							$.each(data.errors, function( index, value ) {
								toastr.error(value);
							});
						}
					},
					error:function(data){
						if(data.responseJSON.message){
							toastr.error(data.responseJSON.message);
						}
						$.each(data.responseJSON.errors, function( index, value ) {
							toastr.error(value);
							$('.form-control[name='+index+']').addClass('is-invalid');
							$('.form-control[name='+index+']').parent().append('<span id="password-error" class="error invalid-feedback">'+value+'</span>');
						});
					},
					complete: function (data) {
						_this.children('i').removeClass('fa-spin');
						_this.children('i').removeClass('fa-circle-notch');
						_this.children('i').removeClass('fas');
						_this.children('i').addClass('fa-paper-plane');
						_this.prop('disabled', false);
					}
				});
			}else{
				_this.children('i').removeClass('fa-spin');
				_this.children('i').removeClass('fa-circle-notch');
				_this.children('i').removeClass('fas');
				_this.children('i').addClass('fa-paper-plane');
				_this.prop('disabled', false);
			}
			e.preventDefault();
		});


		var currentTab = 0;
		showTab(currentTab);

		function showTab(n) {
			var x = document.getElementsByClassName("tab");
			for (i = 0; i < x.length; i++) {
				x[i].className = x[i].className.replace(" active", "");
			}
			x[n].className += " active";
			x[n].style.display = "block";
			if (n == 0) {
				document.getElementById("prevBtn").style.display = "none";
			} else {
				document.getElementById("prevBtn").style.display = "inline";
			}
			if (n == (x.length - 1)) {
				document.getElementById("nextBtn").style.display = "none";
				if(document.getElementById("submitBtn")!==null){
					document.getElementById("submitBtn").style.display = "inline";
				}
			} else {
				document.getElementById("nextBtn").style.display = "inline";
				if(document.getElementById("submitBtn")!==null){
					document.getElementById("submitBtn").style.display = "none";
				}
			}
			if(x.length>1){
				fixStepIndicator(n)
			}
		}

		function nextPrev(n) {
			var x = document.getElementsByClassName("tab");
			if (n == 1 && validateForm()===false){ return false; }
			x[currentTab].style.display = "none";
			currentTab = currentTab + n;
			showTab(currentTab);
		}

		function validateForm() {
			var vaild = true;
			$('.tab.active .form-control').each(function(i){
				if($(this).val()=="" || $(this).val()=="0" || $(this).val()==null){
					toastr.error('plz, fill all fields.');
					$(this).addClass('is-invalid');
					vaild = false;
				}
			});
			return vaild;
		}

		function fixStepIndicator(n) {
			var i, x = document.getElementsByClassName("step");
			for (i = 0; i < x.length; i++) {
				x[i].className = x[i].className.replace(" active", "");
			}
			x[n].className += " active";
		}
	</script>

@endsection
