@extends('customer.layout')
@section('content')
    <div class="row">
        <form class="col-12" action="{{route('customer.tickets.store')}}" method="post">
            @csrf
            <div class="card">
                <div class="card-body col-12">

                <div class="form-group row">
                    <label for="title" class="col-sm-2 col-form-label">{{__('Subject')}}</label>
					<div class="col-sm-10">
	                    <input type="text" name="title" class="form-control" />
	                </div>
                </div>

				<div class="form-group row">
					<label for="department" class="col-sm-2 col-form-label">{{__('Department')}}</label>
					<div class="col-sm-10">
						<select class="form-control select2" data-placeholder="Select Department" id="department" name="department" placeholder="Select Department">
							@foreach(\App\SupportDepartment::get() as $department)
								<option value="{{$department->id}}">
									{{$department['name_'.\Config::get('app.locale')]}}
								</option>
							@endforeach
						</select>
					</div>
				</div>

                <div class="form-group">
                    <label for="description">{{__('Description')}}</label>
                    <textarea name="description" class="col-12 summernote"></textarea>
                </div>
                <button class="btn btn-success col-12">{{__('Submit')}}</button>
            </div>
            </div>

        </form>
    </div>
@endsection
