@extends('customer.layout')
@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body bg-secondary text-white col-12">
                    <div class="row">
						<div class="col-8">
							<h4 class="card-title">{{__('Recent Tickets')}}</h4>
						</div>
						<div class="col-4 text-not-as-lang">
							<a class="btn btn-light align-content-end" href="{{route('customer.tickets.create')}}">
								{{__('Open Ticket')}}
							</a>
						</div>
                    </div>

                </div>

                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-light">
                        <tr>
                            <th scope="col">{{__('Ticket ID')}}</th>
                            <th scope="col">{{__('Title')}}</th>
                            <th scope="col">{{__('Status')}}</th>
                            <th scope="col">{{__('View')}}</th>
                        </tr>
                        </thead>
                        <tbody class="customtable">
							@forelse($tickets as $ticket)
	                            <tr>
	                                <td>{{$ticket->ticket_uuid}}</td>
	                                <td>{{$ticket->title}}</td>
	                                <td>{{__($ticket->status)}}</td>
	                                <td><a class="btn btn-dark" href="{{route('customer.tickets.view',$ticket->ticket_uuid)}}">{{__('View')}}</a></td>
	                            </tr>
							@empty
								<tr><td colspan="4">{{__('you haven\'t created any ticket yet')}}</td></tr>
							@endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
