@php
	/*
	$user = \App\User::where('id','13')->first();
	Auth::login($user);
	*/
@endphp

<!DOCTYPE html>
<html lang="{{Config::get('app.locale')}}">

    <head>

        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />

        <title>{{ config('app.name')[Config::get('app.locale')] . " | " . $title }}</title>

        <!-- Tell the browser to be responsive to screen width -->
        <meta name="viewport" content="width=device-width, initial-scale=1" />

        <!-- Font Awesome -->
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.14.0/css/all.min.css" integrity="sha512-1PKOgIY59xJ8Co8+NE6FZ+LOAZKjy+KY8iq0G4B3CyeY6wYHN3yt9PW0XpSriVlkMXe40PTKnXrLnZ9+fkDaog==" crossorigin="anonymous" />
        <!-- overlayScrollbars -->
        <link rel="stylesheet" href="{{ asset("/plugins/adminlte/css/adminlte.min.css") }}" />

        <!-- Google Font: Source Sans Pro -->
        <link rel="stylesheet" href="{{ asset("/plugins/toastr/toastr.min.css") }}" />

        <!-- Google Font: Source Sans Pro -->
        <link rel="stylesheet" href="{{ asset("/plugins/select2/css/select2.min.css") }}" />

		<!-- overlayScrollbars -->
	    <link rel="stylesheet" href="{{ asset("plugins/overlayScrollbars/css/OverlayScrollbars.min.css") }}">

		<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet" />

        <link rel="stylesheet" href="{{ asset("/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css") }}" />
        <link rel="stylesheet" href="{{ asset("/plugins/datatables-buttons/css/buttons.bootstrap4.min.css") }}" />

        <!-- Google Font: Source Sans Pro -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <!-- Google Font: Source Sans Pro -->
        <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet" />

        <link rel="stylesheet" href="{{ asset("/plugins/jquery-nestable/style.css") }}">
        <link rel="stylesheet" href="{{ asset("/plugins/afrodien/css/dashboard.app.css") }}">

        @if( json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']=="rtl")
        <link rel="stylesheet" href="{{ asset("/plugins/afrodien/css/dashboard.app.rtl.css") }}">
        @endif

		@if( json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['prefix']=="ar")
			<link rel="preload" as="style" href="https://fonts.googleapis.com/css2?family=Almarai&display=swap" onload="this.rel='stylesheet'">
		@endif


        <!-- jQuery -->
        <script src="{{ asset("/plugins/jquery/jquery.min.js") }}"></script>

		<link rel="shortcut icon" href="{{url('/storage/'.config('app.favicon'))}}">

		<base href="{{url('')}}" />
		<meta name="home" content="{{route('frontend.index')}}" />

		<script type="text/javascript">
			var languages = {!! json_encode(Config::get('app.languages')) !!};
            var dataTableLanguage = {
                "lengthMenu": "{{__(('sLengthMenu'))}}",
                "zeroRecords": "{{__(('sEmptyTable'))}}",
                "info": "{{__(('sInfo'))}}",
                "processing": "{{__(('sProcessing'))}}",
                "infoEmpty": "{{__(('sInfoEmpty'))}}",
                "infoFiltered": "{{__(('sInfoFiltered'))}}",
                "zeroRecords": "{{__(('sZeroRecords'))}}",
                "emptyTable": "{{__(('sEmptyTable'))}}",
                "search": '<i class="fas fa-search"></i>',
                paginate: {
                    "next" : "{{__(('oPaginate.sNext'))}}",
                    "previous" : "{{__(('oPaginate.sPrevious'))}}",
                },
                buttons: {
                    pageLength: {
                        _: '<i class="fas fa-list"></i> %d',
                        '-1': '<i class="fas fa-td"></i> all',
                    }
                }
            };
		</script>

    </head>

    <body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed">

        <!-- Site wrapper -->
        <div class="wrapper">
            <!-- Navbar -->
            <nav class="main-header navbar navbar-expand navbar-white navbar-light">
                @include('dashboard.inc.nav')
            </nav>
            <!-- /.navbar -->

            <!-- Main Sidebar Container -->
            <aside class="main-sidebar sidebar-dark-primary elevation-4">
                @include('dashboard.inc.aside')
            </aside>

            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6">
                                <h1>{{$title}}</h1>
                            </div>
                            <div class="col-sm-6">
                                <ol class="breadcrumb float-sm-right">
                                    <li class="breadcrumb-item"><a href="{{ route('dashboard.index', []) }}">{{__('Dashboard')}}</a></li>
                                    <li class="breadcrumb-item active">{{$title}}</li>
                                </ol>
                            </div>
                        </div>
                    </div><!-- /.container-fluid -->
                </section>

                <!-- Main content -->
                @yield('content')
                <!-- /.content -->
            </div>
            <!-- /.content-wrapper -->

            <footer class="main-footer">
                @include('dashboard.inc.footer')
            </footer>

            <!-- Control Sidebar -->
            <aside class="control-sidebar control-sidebar-dark">
                @include('dashboard.inc.help')
            </aside>
            <!-- /.control-sidebar -->

            <form id="logout-form" action="{{ route('logout' , []) }}" method="POST" style="display: none;">
                @csrf
            </form>

        </div>
        <!-- ./wrapper -->





        <!-- Demo >> leave feedback -->
        <button type="button" class="feedback-icon" data-toggle="modal" data-target="#feadbackModal"> <span class="far fa-comment-alt"></span> &nbsp;&nbsp; {{__('Leave Feedback')}}</button>
        <!-- Modal -->
        <form action="{{route('dashboard.feedback')}}" class="modal fade" id="feadbackModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{__('Feedback')}}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="feadback-box">
                            <div class="form-group">
                                <label class="form-label" for="feedback">{{__('Leave Feedback')}}</label>
                                <textarea class="form-control" id="Message" name="Message" placeholder="{{__('Write your feedback')}}"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" id="close-feedback" class="btn btn-secondary" data-dismiss="modal">{{__('Close')}}</button>
                        <button type="submit" id="submit-feedback" class="btn btn-primary"><i class="fa fa-check"></i> {{__('Send')}}</button>
                    </div>
                </div>
            </div>
        </form>

        <!-- jQuery -->
        <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>

        <!-- Bootstrap 4 -->
        <script src="{{ asset("/plugins/bootstrap/js/bootstrap.bundle.min.js") }}"></script>

        <!-- AdminLTE App -->
        <script src="{{ asset("/plugins/toastr/toastr.min.js") }}"></script>

        <!-- AdminLTE App -->
        <script src="{{ asset("/plugins/select2/js/select2.full.min.js") }}"></script>

		<script src="https://cdn.jsdelivr.net/npm/chart.js@2.9.3/dist/Chart.min.js"></script>

		<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.16/dist/summernote-bs4.min.js"></script>
		<script src="{{ asset("/plugins/summernote-ext/grid.js") }}"></script>
		<script src="{{ asset("/plugins/summernote-ext/directions.js") }}"></script>
		<script src="{{ asset("/plugins/afrodien/js/afrodien-summernote.js") }}"></script>
		<script type="text/javascript" src="/plugins/summernote-files/main.js"></script>

        <script src="{{ asset("/plugins/datatables/jquery.dataTables.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/dataTables.buttons.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.bootstrap4.min.js") }}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.colVis.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.html5.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.print.min.js") }}"></script>

		<!-- Firebase App (the core Firebase SDK) is always required and must be listed first -->
	    <script src="https://www.gstatic.com/firebasejs/7.16.1/firebase-app.js"></script>

	    <!-- If you enabled Analytics in your project, add the Firebase SDK for Analytics -->
	    <script src="https://www.gstatic.com/firebasejs/7.16.1/firebase-analytics.js"></script>

		<!-- Firebase messaging -->
	    <script src="https://www.gstatic.com/firebasejs/7.16.1/firebase-messaging.js"></script>

        <!-- AdminLTE App -->
        <script src="{{ asset("/plugins/adminlte/js/adminlte.min.js") }}"></script>

		<!-- overlayScrollbars -->
		<script src="{{ asset("plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js") }}"></script>

		<!-- Afrodien App JS -->
		<script src="{{ asset("/plugins/afrodien/js/app.js") }}"></script>

		<script src="{{ asset("/plugins/jquery-nestable/jquery.nestable.js") }}"></script>

        <!-- Dashboard JS -->
        <script src="{{ asset("/plugins/afrodien/js/dashboard.app.js") }}"></script>

    </body>

</html>
