@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <form class="card card-primary card-outline" method="post" action="{{route('dashboard.configuration.update')}}" id="form" data-layout="cookie-notification">

                        <div class="card-header">
                            <h3 class="card-title">{{__('Cookie Notification')}}</h3>
                        </div>
                        <div class="card-body">
                            @csrf
                            <nav class="languagesNav">
                                <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                                    @foreach(\Config::get('app.languages') as $language)
                                    <a class="nav-item nav-link @if($language->prefix==\Config::get('app.locale'))  active @endif " id="name_{{$language->prefix}}-tab" data-toggle="tab" href="#name_{{$language->prefix}}" role="tab" aria-controls="name_{{$language->prefix}}" aria-selected="true">{{$language->name}}</a>
                                    @endforeach
                                </div>
                            </nav>
                            <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
                                @foreach(\Config::get('app.languages') as $language)

								<div class="tab-pane fade @if($language->prefix==\Config::get('app.locale'))  show active @endif " id="name_{{$language->prefix}}" role="tabpanel" aria-labelledby="name_{{$language->prefix}}-tab">

									<div class="form-group row">
										<label for="cookie_text_{{$language->prefix}}" class="col-sm-2 col-form-label">{{__('Cookie Notification text')}} [{{$language->prefix}}]</label>
										<div class="col-sm-10">
											<textarea class=" form-control" id="cookie_text_{{$language->prefix}}" name="cookie_text_{{$language->prefix}}" placeholder="Enter Cookie Notification ... ">{{ Config::get('app.cookie.text')[$language->prefix] }}</textarea>
										</div>
									</div>

								</div>

                                @endforeach
                            </div>

                            <div class="form-group row">
                                <label for="cookie_page" class="col-sm-2 col-form-label">{{__('Privacy Page')}}</label>
                                <div class="col-sm-10">
                                    <select class="form-control select2" id="cookie_page" name="cookie_page">
                                        @foreach(\App\Page::get() as $page)
                                        <option value="{{$page->slug}}" @if(\Config::get('app.cookie.page')==$page->slug) selected @endif >{{$page['title_'.\Config::get('app.locale')]}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success">
                                            <input type="checkbox" class="custom-control-input form-control" id="cookie_enabled" name="cookie_enabled" @if(\Config::get('app.cookie.enabled')=='true') checked @endif />
                                            <label class="custom-control-label" for="cookie_enabled">{{__('Cookie Notification Enabled')}}</label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
							<button type="button" id="saveConfiguration" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Save')}}</button>
                        </div>
                        <!-- /.card-footer-->
                    </form>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
@endsection
