@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <form class="card card-primary card-outline" method="post" action="{{route('dashboard.configuration.update')}}" id="form" data-layout="email-templates">

                        <div class="card-header">
                            <h3 class="card-title">{{__('Configuration')}}</h3>
                        </div>
                        <div class="card-body">
                            @csrf

							<div class="form-group row">
								<label for="contact_email" class="col-sm-2 col-form-label">{{__('Contact Thank You Email')}}</label>
								<div class="col-sm-10">
									<textarea class="summernote form-control" id="contact_email" name="contact_email" placeholder="Contact Email ... ">{!! \file_get_contents(\resource_path("views/emails/ThankYouConatctMail.blade.php")) !!}</textarea>
								</div>
							</div>

							<div class="form-group row">
								<label for="newsletter_email" class="col-sm-2 col-form-label">{{__('Newsletter Activation Email')}}</label>
								<div class="col-sm-10">
									<textarea class="summernote form-control" id="newsletter_email" name="newsletter_email" placeholder="Newsletter Email ... ">{!! \file_get_contents(\resource_path("views/emails/verifyNewsletterMail.blade.php")) !!}</textarea>
								</div>
							</div>

                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
							<button type="button" id="saveConfiguration" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Save')}}</button>
                        </div>
                        <!-- /.card-footer-->
                    </form>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
@endsection
