@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <form class="card card-primary card-outline validate-form" data-system="form-builder" data-type="@if(isset($form->id)) edit @else new @endif " data-id="{{$form->id ?? ''}}" action="@if(isset($form->id)) {{ route('dashboard.developers.form-builder.update', [ 'form_id' => $form->id ]) }} @else {{route('dashboard.developers.form-builder.store', [])}} @endif" id="form">
                        <div class="card-header">
                            <h3 class="card-title">{{__('Form')}}</h3>
                        </div>
                        <div class="card-body">
                            <nav class="languagesNav">
                                <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
									@foreach(Config::get('app.languages') as $language)
	                                    <a class="nav-item nav-link @if(Config::get('app.locale')==$language->prefix) active @endif " id="name_{{$language->prefix}}-tab" data-toggle="tab" href="#name_{{$language->prefix}}" role="tab" aria-controls="name_{{$language->prefix}}" aria-selected="true">{{$language->name}}</a>
									@endforeach
									</div>
                            </nav>
                            <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
								@foreach(Config::get('app.languages') as $language)
									<div class="tab-pane fade show @if(Config::get('app.locale')==$language->prefix) active @endif" id="name_{{$language->prefix}}" role="tabpanel" aria-labelledby="name_{{$language->prefix}}-tab">
	                                    <div class="form-group row">
	                                        <label for="input_name_{{$language->prefix}}" class="col-sm-2 col-form-label">{{__('name')}} [{{$language->prefix}}]</label>
	                                        <div class="col-sm-10"><input type="text" class="form-control" id="input_name_{{$language->prefix}}" name="name_{{$language->prefix}}" placeholder="{{__('Enter Your system Name')}} ... " value="{{$form['name_'.$language->prefix] ?? ''}}" /></div>
	                                    </div>
	                                </div>
								@endforeach
                            </div>

                            <div class="row">
                                <div class="col-12 table-responsive">
                                    <table class="table table-striped formdata" id="SystemFields">
                                        <thead>
                                        <tr>
                                            <th data-name="label">{{__('Label')}}</th>
                                            <th data-name="name">{{__('Name')}}</th>
                                            <th data-name="type">{{__('Type')}}</th>
                                            <th class="actions">{{__('Actions')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody data-name="system_fields" class="ui-sortable">
                                            @if(isset($form->fields))
                                                @foreach ($form->fields as $item)
                                                    <tr
                                                        data-is_required="@isset($item['is_required']) {{$item['is_required']}} @endisset"
                                                        data-unique="@isset($item['unique']) {{$item['unique']}} @endisset"
                                                        data-type="@isset($item['type']) {{$item['type']}} @endisset"
                                                        data-name="@isset($item['name']) {{$item['name']}} @endisset"
                                                        data-values='@if(isset($item['values'])) {{ json_encode($item['values']) }} @else [] @endif'
                                                        @foreach (Config::get('app.languages') as $language)
                                                        data-label_{{$language->prefix}}="{{$item['label'][$language->prefix]}}"
                                                        @endforeach
                                                    >
                                                        <td data-field="label">{{$item['label'][Config::get('app.locale')]}}</td>
                                                        <td data-field="name">{{$item['name']}}</td>
                                                        <td data-field="type">{{$item['type']}}</td>
                                                        <td class="actions">
                                                            <button type="button" class="btn btn-sm btn-danger deleteRow">
                                                                <i class="fa fa-trash"></i>
                                                            </button>

                                                            <button type="button" class="btn btn-sm btn-info edit_form_input"
                                                                    data-toggle="modal" data-target=".modal">
                                                                <i class="fa fa-edit"></i>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @endif
                                        </tbody>
                                        <tfoot>
                                        <tr>
                                            <td>
                                                <nav class="languagesNav">
                                                    <div class="nav nav-tabs nav-fill" id="label-nav-tab" role="tablist">
														@foreach(Config::get('app.languages') as $language)
															<a class="nav-item nav-link @if(Config::get('app.locale')==$language->prefix) active @endif" id="item_label_tabs_{{$language->prefix}}-tab" data-toggle="tab" href="#item_label_tabs_{{$language->prefix}}" role="tab" aria-controls="item_label_tabs_{{$language->prefix}}" aria-selected="true">{{$language->name}}</a>
														@endforeach
                                                    </div>
                                                </nav>
                                                <div class="tab-content py-3 px-3 px-sm-0" id="label-nav-tabContent">
													@foreach(Config::get('app.languages') as $language)
														<div class="tab-pane fade show @if(Config::get('app.locale')==$language->prefix) active @endif" id="item_label_tabs_{{$language->prefix}}" role="tabpanel" aria-labelledby="item_label_tabs_{{$language->prefix}}-tab">
	                                                        <div class="form-group row">
	                                                            <label for="item_label_{{$language->prefix}}" class="form-label">{{__('Input Label')}} [{{$language->prefix}}]</label><input type="text" class="form-control" id="item_label_{{$language->prefix}}" name="item_label_{{$language->prefix}}" placeholder="{{__('Enter input label')}} ... " />
	                                                        </div>
	                                                    </div>
													@endforeach
                                                </div>
                                            </td>
                                            <td><label for="item_name" class="form-label">{{__('Input name')}}</label><input class="form-control" type="text" placeholder="{{__('input name')}}" id="item_name" /></td>
                                            <td>
                                                <label for="item_type" class="form-label">{{__('Input type')}}</label>
                                                <select class="form-control select2" id="item_type">
													<option value="text">text (varchar 255)</option>
					                                <option value="number">number</option>
													<option value="image">image</option>
					                                <option value="file">file</option>
					                                <option value="options">options</option>
					                                <option value="long_text">long_text (text)</option>
					                                <option value="email">email</option>
					                                <option value="password">password</option>
					                                <option value="date">date</option>
					                                <option value="datetime">datetime</option>
                                                </select>
                                            </td>
                                            <td>
                                                <button id="add_form_input" type="button" class="btn btn-sm btn-success">{{__('Add')}} <i class="fa fa-plus-circle"></i></button>
                                            </td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="notes">{{__('Notes')}}</label>
                                <textarea class="form-control" id="notes" name="notes" placeholder="{{__('Write notes')}}">{{$form->notes ?? ''}}</textarea>
                            </div>
                        </div>

                        <!-- /.card-body -->
                        <div class="card-footer text-right">
                            <a href="{{route('dashboard.developers.form-builder', [] )}}" class="btn btn-sm btn-secondary"><i class="fa fa-arrow-left"></i> {{__('Back')}}</a>
                            <button type="button" id="build_form" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Save')}}</button>
                        </div>
                        <!-- /.card-footer-->
                    </form>
                </div>
                <!-- /.card -->
            </div>
        </div>
    </section>


    <!-- The Modal -->
    <div class="modal hide fade" role="dialog" aria-hidden="true" id="editFormInput">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">{{__('Edit Input')}}</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">

                    <form method="post">

                        <nav class="languagesNav">
                            <div class="nav nav-tabs nav-fill" id="nav-tab2" role="tablist">
                                @foreach(Config::get('app.languages') as $language)
                                    <a class="nav-item nav-link @if(Config::get('app.locale')==$language->prefix) active @endif " id="item_label_tabs_{{$language->prefix}}-tab2" data-toggle="tab" href="#item_label_tabs_{{$language->prefix}}2" role="tab" aria-controls="item_label_tabs_{{$language->prefix}}2" aria-selected="true">{{$language->name}}</a>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent2">
                            @foreach(Config::get('app.languages') as $language)
                            <div class="tab-pane fade @if(Config::get('app.locale')==$language->prefix) active show @endif" id="item_label_tabs_{{$language->prefix}}2" role="tabpanel" aria-labelledby="item_label_tabs_{{$language->prefix}}-tab2">
                                <div class="form-group row">
                                    <label for="item_label_{{$language->prefix}}" class="form-label">{{__('Input Label')}} [{{$language->prefix}}]</label>
                                    <input type="text" class="form-control" id="item_label_{{$language->prefix}}2" name="item_label_{{$language->prefix}}2" placeholder="{{__('Enter input label')}} ... " />
                                </div>
                            </div>
                            @endforeach
                        </div>

                        <div class="form-group">
                            <label for="item_name2" class="form-label">{{__('Input name')}}</label>
                            <input class="form-control" type="text" placeholder="{{__('input name')}}" id="item_name2" />
                        </div>

                        <div class="form-group">
                            <label for="item_type2" class="form-label">{{__('Input type')}}</label>
                            <select class="form-control select2" id="item_type2">
                                <option value="text">text (varchar 255)</option>
                                <option value="number">number</option>
								<option value="image">image</option>
                                <option value="file">file</option>
                                <option value="options">options</option>
                                <option value="long_text">long_text (text)</option>
                                <option value="email">email</option>
                                <option value="password">password</option>
                                <option value="date">date</option>
                                <option value="datetime">datetime</option>
                            </select>
                        </div>


                        <div class="row">
                            <div class="col-4">
                                <div class="icheck-primary">
                                    <input type="checkbox" name="is_required" id="is_required" />
                                    <label for="is_required">{{__("Is required")}}</label>
                                </div>
                            </div>

							<div class="col-4">
                                <div class="icheck-primary">
                                    <input type="checkbox" name="unique" id="unique" />
                                    <label for="unique">{{__('Unique')}}</label>
                                </div>
                            </div>

                        </div>

                        <br>

                        <div id="selectOptions">
                            <table class="table table-striped formdata" id="OptionsTable">
                                <thead>
                                <tr>
                                    @foreach(Config::get('app.languages') as $language)
                                    <th>{{__('Option')}} [{{$language->prefix}}] </th>
                                    @endforeach
                                    <th>{{__('Value')}}</th>
                                    <th>{{__('Actions')}}</th>
                                </tr>
                                </thead>
                                <tbody>

                                </tbody>
                                <tfoot>
                                <tr>
                                    @foreach(Config::get('app.languages') as $language)
                                    <td><input type="text" class="form-control" id="option_{{$language->prefix}}" placeholder="{{__('Option')}} [{{$language->prefix}}]" /></td>
                                    @endforeach
                                    <td><input type="text" class="form-control" id="value" placeholder="{{__('Value')}}" /></td>
                                    <td><button type="button" class="btn btn-success" id="add_new_option"><i class="fa fa-plus-circle"></i> {{__('Add')}}</button></td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>

                    </form>



                </div>

                <!-- Modal footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-success" data-dismiss="modal" id="updateFormInput">{{__('Save')}}</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">{{__('Close')}}</button>
                </div>

            </div>
        </div>
    </div>





	<!-- Modal -->
<div class="modal fade" id="editRowModal" tabindex="-1" role="dialog" aria-labelledby="editRowModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">{{__('Edit Option')}}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
			<div class="form-group row">
	  			<label for="slug" class="col-sm-2 col-form-label">{{__('value')}}</label>
	  			<div class="col-sm-10">
	  				<input type="text" class=" form-control" id="optionValue" name="optionValue" placeholder="{{__('Enter option value')}} ... " />
	  			</div>
	  		</div>

	  		@foreach(Config::get('app.languages') as $language)
	  			<div class="form-group row">
	  				<label for="title_{{$language->prefix}}" class="col-sm-2 col-form-label">{{__('option labele')}} [{{$language->prefix}}]</label>
	  				<div class="col-sm-10">
	  					<input type="text" class=" form-control" id="edit_option_{{$language->prefix}}" name="option_{{$language->prefix}}" placeholder="{{__('Enter option label')}} ... " />
	  				</div>
	  			</div>
	  		@endforeach

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('Close')}}</button>
        <button type="button" id="SaveOptions" data-dismiss="modal" class="btn btn-primary">{{__('Save changes')}}</button>
      </div>
    </div>
  </div>
</div>
@endsection
